package com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessagingInstitutionalPageBsProperties {

    /**
     * Bean name of the consumer handler.
     */
    @NotBlank
    private String consumerHandlerBeanName;

    /**
     * Event type string used for resource event status change event.
     */
    @NotBlank
    private String resourceStatusChangeEventType;

    /**
     * Event type string used for join request status change Event.
     */
    @NotBlank
    private String joinRequestStatusChangeEventType;

    /**
     * Event type string used for member invitation status change Event.
     */
    @NotBlank
    private String memberInvitationStatusChangeEventType;

    /**
     * Event type string used for membership change Event.
     */
    @NotBlank
    private String membershipChangeEventType;

    /**
     * Event type string used for membership removal Event.
     */
    @NotBlank
    private String membershipRemovalEventType;
}
