package com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties for the user profile bs service.
 * <p>
 * These properties are mapped from the {@code user-profile.bs} prefix in the application configuration.
 */
@Data
@Validated
@ConfigurationProperties(prefix = "user-profile.bs")
public class UserProfileBsConfigurationProperties {

    /**
     * Base URL used by Swagger/OpenAPI documentation.
     * Example: {@code http://localhost:8080}
     */
    @NotBlank
    private String swaggerApiServerUrl;

    /**
     * Messaging-related configuration properties.
     */
    @NotNull
    @Valid
    private Messaging messaging;

    /**
     * Configuration for messaging
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Messaging {

        /**
         * Name of the configured producer
         */
        @NotBlank
        private String producerName;

        /**
         * Name of the configured event producer
         */
        @NotBlank
        private String eventProducerName;

        /**
         * Source identifier for events, used to indicate the origin of a message.
         */
        @NotBlank
        private String source;

        /**
         * Event type string used for resource creation events.
         */
        @NotBlank
        private String resourceCreatedType;

        /**
         * Event type string used for resource update events.
         */
        @NotBlank
        private String resourceUpdatedType;

        /**
         * Event type string used for resource deletion events.
         */
        @NotBlank
        private String resourceDeletedType;

        /**
         * Event type string used for creation events.
         */
        @NotBlank
        private String eventCreatedType;

        /**
         * Event type string used for update events.
         */
        @NotBlank
        private String eventUpdatedType;

        /**
         * Event type string used for deletion events.
         */
        @NotBlank
        private String eventDeletedType;

        /**
         * Event type string used for cv update events.
         */
        @NotBlank
        private String eventCvUpdatedType;

        /**
         * Event type string used for image update events.
         */
        @NotBlank
        private String eventImageUpdatedType;

        /**
         * Event type string used for language update events.
         */
        @NotBlank
        private String eventLanguageUpdatedType;

        /**
         * Event type string used for interests events.
         */
        @NotBlank
        private String eventInterestsType;

        /**
         * Event type string used for catalog interests events.
         */
        @NotBlank
        private String eventCatalogInterestsType;

        /**
         * Event type string used for endorsement events.
         */
        @NotBlank
        private String eventEndorsementType;

        /**
         * Configuration for institutional-page-bs messaging.
         */
        @NotNull
        @Valid
        private MessagingInstitutionalPageBsProperties institutionalPageBs;

        /**
         * Configuration for catalog-bs messaging.
         */
        @NotNull
        @Valid
        private MessagingCatalogBsProperties catalogBs;

    }
}
