package com.finconsgroup.itserr.marketplace.userprofile.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.SecurityRoles;
import com.finconsgroup.itserr.marketplace.userprofile.bs.api.AdminApi;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.service.UserProfileService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller for handling UserProfile-related API requests.
 *
 * <p>Implements the {@link AdminApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class AdminController implements AdminApi {

    @Value("${user-profile.bs.security.audience}")
    private String securityAudience;

    private final UserProfileService userProfileService;

    @Override
    public OutputAdminPatchUserProfileDto patchUserProfile(UUID profileId, InputAdminPatchUserProfileDto inputAdminPatchUserProfileDto) {
        return userProfileService.patchUserProfile(profileId, inputAdminPatchUserProfileDto);
    }

    @Override
    public void publishAllProfilesMessages() {
        // TODO use proper role when available
        if (!JwtTokenHolder.getRoles(securityAudience).contains(SecurityRoles.CATALOGUE_MODERATE_ROLE)) {
            throw new WP2AuthorizationException("Forbidden");
        }
        userProfileService.publishAllProfilesMessages();
    }
}
