package com.finconsgroup.itserr.marketplace.userprofile.bs.controller;

import com.finconsgroup.itserr.marketplace.userprofile.bs.api.EndorsementApi;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputEndorsementAcknowledgementDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.service.UserProfileService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling user endorsement related API requests.
 *
 * <p>Implements the {@link EndorsementApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class EndorsementController implements EndorsementApi {

    private final UserProfileService userProfileService;

    @Override
    public OutputEndorsementAcknowledgementDto addEndorsement(UUID profileId, UUID expertiseId) {
        return userProfileService.addEndorsement(profileId, expertiseId);
    }

    @Override
    public void removeEndorsement(UUID profileId, UUID expertiseId) {
        userProfileService.removeEndorsement(profileId, expertiseId);
    }
}
