package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.userprofile.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * DTO for Reference details.
 */
@Schema(name = "InputManualReferenceDto", description = "DTO for manual reference details")
@Data
@Builder
@AllArgsConstructor
public class InputManualReferenceDto {

    @Schema(description = "Title", example = "Advancements in Neural Network Architectures for Complex Tasks")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String title;

    @Schema(description = "Journal or Conference", example = "Journal of Artificial Intelligence Research")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String journalOrConference;

    @Schema(description = "URL of the Publication", example = "https://example.com/publication/xyz123")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String url;

    @Schema(description = "Volume - typical for journals", example = "2")
    private String volume;

    @Schema(description = "Page range where the article, chapter, or cited contribution appears", example = "pp. 45–58")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String pages;

    @Schema(description = "paragraph", example = "10")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String paragraph;

    @Schema(description = "publication details")
    @Valid
    private InputPublicationDto publication;

    @Schema(description = "List of authors")
    @Valid
    private List<InputAuthorDto> authors;
}
