package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "Item",
        description = "Represents an item inside a folder in a workspace")

public class ItemDto {

    @Schema(description = "Unique identifier of the item", example = "7033aad8-3519-44a0-ab44-9999999")
    private String id;

    @Schema(description = "Name of the item", example = "whatsapp-logo-transparent-free.png")
    private String name;

    @Schema(description = "Full path of the item", example = "/Home/user/Workspace/File.png")
    private String path;

    @Schema(description = "Parent item ID", example = "86e5ae44-c0db-4314-8513-999999999")
    private String parentId;

    @Schema(description = "Parent item path", example = "/Home/user/Workspace")
    private String parentPath;

    @Schema(description = "Primary type of the item", example = "nthl:externalFile")
    private String primaryType;

    @Schema(description = "Indicates if the item is trashed", example = "false")
    private boolean trashed;

    @Schema(description = "Indicates if the item is externally managed", example = "false")
    private boolean externalManaged;

    @Schema(description = "Indicates if the item is shared", example = "false")
    private boolean shared;

    @Schema(description = "Indicates if the item is locked", example = "false")
    private boolean locked;

    @Schema(description = "Indicates if the item is public", example = "false")
    private boolean publicItem;

    @Schema(description = "Title of the item", example = "logo.png")
    private String title;

    @Schema(description = "Description of the item", example = "Image file used for testing")
    private String description;

    @Schema(description = "User who last modified the item", example = "user.surname9923")
    private String lastModifiedBy;

    @Schema(description = "Last modification time in yyyy-MM-dd HH:mm:ss format", example = "2025-03-19 09:23:48")
    private String lastModificationTime;

    @Schema(description = "Creation time in yyyy-MM-dd HH:mm:ss format", example = "2025-03-19 09:23:48")
    private String creationTime;

    @Schema(description = "Owner of the item", example = "name.surname89674")
    private String owner;

    @Schema(description = "Last action performed on the item", example = "CREATED")
    private String lastAction;

    @Schema(description = "Indicates if the item is hidden", example = "false")
    private boolean hidden;

    @Schema(description = "Indicates the privileges on a folder", example = "read")
    private String privilege;

    @Schema(description = "Indicates if is a vreFolder", example = "false")
    private boolean vreFolder;

    @Schema(description = "Indicates the name to Display", example = "James White")
    private String displayName;

    @Schema(description = "Indicates the url for Reference", example = "http://localhost/document/reference/123.pdf")
    private String value;
}