package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Output DTO representing a manual reference.
 */
@Schema(name = "OutputManualReferenceDto", description = "DTO representing a manual reference in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputManualReferenceDto {

    @Schema(description = "Title", example = "Advancements in Neural Network Architectures for Complex Tasks")
    private String title;

    @Schema(description = "Journal or Conference", example = "Journal of Artificial Intelligence Research")
    private String journalOrConference;

    @Schema(description = "URL of the Publication", example = "https://example.com/publication/xyz123")
    private String url;

    @Schema(description = "Volume - typical for journals", example = "2")
    private String volume;

    @Schema(description = "Page range where the article, chapter, or cited contribution appears", example = "pp. 45–58")
    private String pages;

    @Schema(description = "paragraph", example = "10")
    private String paragraph;

    @Schema(description = "publication details")
    private OutputPublicationDto publication;

    @Schema(description = "List of authors")
    private List<OutputAuthorDto> authors;
}
