package com.finconsgroup.itserr.marketplace.userprofile.bs.enums;


/**
 * Enumeration representing resource lifecycle events for debugging and analysis purposes.
 * <p>
 * <b>Note:</b> This enum is intended solely for diagnostic use and should not be used
 * in production business logic.
 *
 * <p>Supported event types:</p>
 * <ul>
 *   <li>{@code CREATED} - Indicates a new resource was created</li>
 *   <li>{@code UPDATED} - Indicates an existing resource was modified</li>
 *   <li>{@code DELETED} - Indicates a resource was removed</li>
 *   <li>{@code CV_UPDATED} - Indicates a user has updated CV</li>
 *   <li>{@code IMAGE_UPDATED} - Indicates a user has updated image</li>
 *   <li>{@code LANGUAGE_UPDATED} - Indicates a user has updated language</li>
 *   <li>{@code INTERESTS} - Indicates a resource matching user interests was created</li>
 * </ul>
 *
 * @since 1.0
 */
public enum MessagingEventType {
    CREATED,
    UPDATED,
    DELETED,
    CV_UPDATED,
    IMAGE_UPDATED,
    LANGUAGE_UPDATED,
    INTERESTS,
    ENDORSEMENT
}
