package com.finconsgroup.itserr.marketplace.userprofile.bs.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsement;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterests;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileEndorsementMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileInterestsMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

@Mapper(
        componentModel = "spring"
)
public interface UserProfileMapper {

    String MAP_EVENT_NAME = "mapEventName";

    /**
     * Converts a {@link OutputUserProfileDto} into a {@link MessagingEventDto}.
     *
     * @param userProfileDto user profile.
     * @return Created messaging event DTO.
     */
    @Mapping(target = "name", source = "userProfileDto", qualifiedByName = MAP_EVENT_NAME)
    @Mapping(target = "title", source = "preferredUsername")
    @Mapping(target = "category", ignore = true)
    @Mapping(target = "timestamp", ignore = true)
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<UserProfileMessagingAdditionalDataDto> toMessagingEventDto(OutputUserProfileDto userProfileDto);

    /**
     * Converts a {@link OutputUserProfileDto} into a {@link MessagingEventDto}.
     *
     * @param userProfileInterests user profile interests.
     * @return Created messaging event DTO.
     */
    @Mapping(target = "timestamp", ignore = true)
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<UserProfileInterestsMessagingAdditionalDataDto> toMessagingEventDto(UserProfileInterests userProfileInterests);

    /**
     * Converts a {@link UserProfileEndorsement} into a {@link MessagingEventDto}.
     *
     * @param userProfileEndorsement user profile endorsement.
     * @return Created messaging event DTO.
     */
    @Mapping(target = "timestamp", ignore = true)
    @Mapping(target = "category", ignore = true)
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<UserProfileEndorsementMessagingAdditionalDataDto> toMessagingEventDto(UserProfileEndorsement userProfileEndorsement);

    @Named(MAP_EVENT_NAME)
    default String mapEventName(OutputUserProfileDto userProfileDto) {
        return String.format("%s %s", userProfileDto.getFirstName(), userProfileDto.getLastName());
    }
}
