package com.finconsgroup.itserr.marketplace.userprofile.bs.util;

import java.util.Locale;

/**
 * Supported user languages.
 */
public enum Language {
    IT,
    EN;

    /**
     * Converts a string to its corresponding Language enum.
     *
     * @param lang the input string (e.g. "it", "EN")
     * @return the matching Language
     * @throws IllegalArgumentException if the input is null or not one of the supported values
     */
    public static Language fromString(String lang) {
        if (lang == null) {
            throw new IllegalArgumentException("Language must not be null");
        }
        try {
            return Language.valueOf(lang.trim().toUpperCase(Locale.ROOT));
        } catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(
                    "Unsupported language: " + lang + ". Supported values are: IT, EN", ex);
        }
    }
}
