/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.client;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAddProjectToUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputFindUserProfilesByInterestsDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputFindUserProfilesByPrincipalsDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputPatchUserProfileProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputRemoveProjectFromUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputUserProfileFolderDetails;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputEndorsementAcknowledgementDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

public interface UserProfileDmClient {
    @GetMapping(value={"/profile/folder"})
    public OutputUserProfileFolderDetails getProfileFolder();

    @PatchMapping(value={"/profile"})
    public OutputPatchUserProfileDto patchUserProfile(InputPatchUserProfileDto var1);

    @PostMapping(value={"/profile"})
    public OutputUserProfileDto create(InputUserProfileDto var1);

    @PutMapping(value={"/profile"})
    public OutputUserProfileDto updateById(InputUpdateUserProfileDto var1);

    @GetMapping(value={"/profile"}, produces={"application/json"})
    public OutputUserProfileDto findById();

    @PostMapping(value={"/profiles-by-principals"}, consumes={"application/json"}, produces={"application/json"})
    public Page<OutputUserProfileDto> findAllByPrincipals(@RequestBody InputFindUserProfilesByPrincipalsDto var1, @RequestParam(name="pageNumber") int var2, @RequestParam(name="pageSize") int var3, @RequestParam(name="sort") String var4, @RequestParam(name="direction") SortDirection var5);

    @PostMapping(value={"/profiles/project"}, consumes={"application/json"}, produces={"application/json"})
    public List<OutputUserProfileDto> addProjectToUserProfiles(@RequestBody InputAddProjectToUserProfilesDto var1);

    @DeleteMapping(value={"profiles/project"}, consumes={"application/json"}, produces={"application/json"})
    public List<OutputUserProfileDto> removeProjectFromUserProfiles(@RequestBody InputRemoveProjectFromUserProfilesDto var1);

    @GetMapping(value={"/profiles/{profileId}"}, produces={"application/json"})
    public OutputUserProfileDto getById(@PathVariable(value="profileId") UUID var1);

    @PatchMapping(value={"/profiles/projects"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputUserProfileDto> patchUserProfileProject(@Valid @RequestBody InputPatchUserProfileProjectDto var1);

    @PatchMapping(value={"/admin/profile/{profileId}"}, produces={"application/json"})
    public OutputAdminPatchUserProfileDto patchUserProfile(@PathVariable(value="profileId") UUID var1, @RequestBody InputAdminPatchUserProfileDto var2);

    @GetMapping(value={"/profiles"}, produces={"application/json"})
    public OutputPageDto<OutputUserProfileDto> findAll(@RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var1, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var2, @RequestParam(name="sort", defaultValue="id", required=false) String var3, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var4);

    @PostMapping(value={"/profile/activate"}, produces={"application/json"})
    public void activate();

    @DeleteMapping(value={"/profile/activate"}, produces={"application/json"})
    public void deactivate();

    @PostMapping(value={"/profile-ids-by-interests"}, consumes={"application/json"}, produces={"application/json"})
    public List<UUID> findMatchingInterests(@Valid @RequestBody InputFindUserProfilesByInterestsDto var1);

    @PostMapping(value={"/profiles/{profileId}/expertise/{expertiseId}/confirm"}, produces={"application/json"})
    public OutputEndorsementAcknowledgementDto addEndorsement(@PathVariable(value="profileId") UUID var1, @PathVariable(value="expertiseId") UUID var2);

    @DeleteMapping(value={"/profiles/{profileId}/expertise/{expertiseId}/confirm"}, produces={"application/json"})
    public void removeEndorsement(@PathVariable(value="profileId") UUID var1, @PathVariable(value="expertiseId") UUID var2);
}

