/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.client;

import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputCreateDocumentDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputCreatedDocumentDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputDocumentPublicLinkDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputUpdatedDocumentDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.FolderDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputFolderCreateDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.WorkspaceDto;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

public interface WorkspaceBsClient {
    @PostMapping(path={"/workspace/folders/{folderId}/documents"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputCreatedDocumentDto createDocument(@PathVariable(value="folderId") @NotBlank String var1, @RequestBody @Valid InputCreateDocumentDto var2);

    @PutMapping(path={"/workspace/documents/{documentId}/content"}, consumes={"application/octet-stream"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUpdatedDocumentDto uploadNewContent(@PathVariable(name="documentId") String var1, @RequestParam(name="fileName") String var2, @RequestBody Resource var3);

    @GetMapping(path={"/workspace/documents/{documentId}/publiclink"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputDocumentPublicLinkDto getPublicLink(@PathVariable(name="documentId") @NotBlank String var1);

    @GetMapping(path={"/workspace"}, produces={"application/json"})
    public WorkspaceDto getWorkspace();

    @PostMapping(path={"workspace/folders/{folderId}/folders"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public String createFolderByFolderId(@PathVariable @NotBlank String var1, @RequestBody InputFolderCreateDto var2);

    @ApiResponses(value={@ApiResponse(responseCode="200", description="Folder found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="404", description="Folder not found")})
    @GetMapping(path={"workspace/folders/{folderId}/folder-by-name"}, produces={"application/json"})
    public FolderDto getFolderByParentFolderIdAndName(@PathVariable String var1, @RequestParam String var2);
}

