/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.userprofile.bs.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.ResourceProducer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    private final ResourceProducer resourceProducer;
    static Map<String, OutputUserProfileDto> userProfileDtoHashMap = new HashMap();
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public ResponseEntity<String> publishMessage(boolean isCreated, boolean isUpdated, boolean isDeleted, String name) {
        OutputUserProfileDto outputUserProfileDto;
        log.debug("call to DiagnosticsController - publishMessage, name: %s".formatted(name));
        if (!(isCreated || isUpdated || isDeleted)) {
            return ResponseEntity.badRequest().body((Object)"One between isCreated, isUpdated, isDeleted should be true");
        }
        if (isCreated) {
            outputUserProfileDto = OutputUserProfileDto.builder().id(UUID.randomUUID()).firstName(name).socialProfile("the CREATED social profile").shortBio("the CREATED short bio").build();
            log.info("sending created message, outputUserProfileDto: %s".formatted(outputUserProfileDto));
            userProfileDtoHashMap.put(outputUserProfileDto.getFirstName(), outputUserProfileDto);
            this.resourceProducer.publishCreatedResource(outputUserProfileDto);
        } else if (isUpdated) {
            outputUserProfileDto = (OutputUserProfileDto)userProfileDtoHashMap.get(name);
            if (outputUserProfileDto == null) {
                return ResponseEntity.badRequest().body((Object)"no test item created for name: %s".formatted(name));
            }
            outputUserProfileDto.setSocialProfile("the UPDATED social profile");
            outputUserProfileDto.setShortBio("the UPDATED short bio");
            log.info("sending updated message, outputUserProfileDto: %s".formatted(outputUserProfileDto));
            this.resourceProducer.publishUpdatedResource(outputUserProfileDto);
        } else {
            outputUserProfileDto = (OutputUserProfileDto)userProfileDtoHashMap.get(name);
            if (outputUserProfileDto == null) {
                return ResponseEntity.badRequest().body((Object)"no test item created for name: %s".formatted(name));
            }
            log.info("sending deleted message, outputUserProfileDto: %s".formatted(outputUserProfileDto));
            userProfileDtoHashMap.remove(outputUserProfileDto.getFirstName());
            this.resourceProducer.publishDeletedResource(outputUserProfileDto);
        }
        return ResponseEntity.ok((Object)"message sent correctly, outputUserProfileDto: %s".formatted(outputUserProfileDto));
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    @Generated
    public DiagnosticsController(ResourceProducer resourceProducer) {
        this.resourceProducer = resourceProducer;
    }
}

