/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.api.UserProfileApi;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserSettingDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.service.UserProfileService;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class UserProfileController
implements UserProfileApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProfileController.class);
    private final UserProfileService userProfileService;

    public OutputUserProfileDto create(InputUserProfileDto inputUserProfileDto) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.userProfileService.create(userId, inputUserProfileDto);
    }

    public OutputUserProfileDto updateById(InputUpdateUserProfileDto inputUpdateUserProfileDto) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.userProfileService.updateById(userId, inputUpdateUserProfileDto);
    }

    public URI uploadImage(MultipartFile image) {
        return this.userProfileService.uploadImage(image);
    }

    public URI uploadCv(MultipartFile cvFile) {
        return this.userProfileService.uploadCv(cvFile);
    }

    public OutputUserSettingDto updateLanguage(String language) {
        return this.userProfileService.updateLanguage(language);
    }

    public List<OutputUserProfileDto> getUserProfilesByRole(String roleName) {
        return this.userProfileService.getUserProfilesByRole(roleName);
    }

    public void activate() {
        this.userProfileService.processUserProfileStatusChange(JwtTokenHolder.getUserIdOrThrow(), Boolean.valueOf(true));
    }

    public void deactivate() {
        this.userProfileService.processUserProfileStatusChange(JwtTokenHolder.getUserIdOrThrow(), Boolean.valueOf(false));
    }

    public Boolean updateHidePanel(Boolean hidePanel) {
        return this.userProfileService.updateHidePanel(hidePanel);
    }

    @Generated
    public UserProfileController(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }
}

