/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputPublicationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="InputManualReferenceDto", description="DTO for manual reference details")
public class InputManualReferenceDto {
    @Schema(description="Title", example="Advancements in Neural Network Architectures for Complex Tasks")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String title;
    @Schema(description="Journal or Conference", example="Journal of Artificial Intelligence Research")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String journalOrConference;
    @Schema(description="URL of the Publication", example="https://example.com/publication/xyz123")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String url;
    @Schema(description="Volume - typical for journals", example="2")
    private String volume;
    @Schema(description="Page range where the article, chapter, or cited contribution appears", example="pp. 45\u201358")
    @Size(max=100, message="field length must be between {min} and {max}")
    private @Size(max=100, message="field length must be between {min} and {max}") String pages;
    @Schema(description="paragraph", example="10")
    @Size(max=100, message="field length must be between {min} and {max}")
    private @Size(max=100, message="field length must be between {min} and {max}") String paragraph;
    @Schema(description="publication details")
    @Valid
    private InputPublicationDto publication;
    @Schema(description="List of authors")
    @Valid
    private List<InputAuthorDto> authors;

    @Generated
    public static InputManualReferenceDtoBuilder builder() {
        return new InputManualReferenceDtoBuilder();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getJournalOrConference() {
        return this.journalOrConference;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getVolume() {
        return this.volume;
    }

    @Generated
    public String getPages() {
        return this.pages;
    }

    @Generated
    public String getParagraph() {
        return this.paragraph;
    }

    @Generated
    public InputPublicationDto getPublication() {
        return this.publication;
    }

    @Generated
    public List<InputAuthorDto> getAuthors() {
        return this.authors;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setJournalOrConference(String journalOrConference) {
        this.journalOrConference = journalOrConference;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setVolume(String volume) {
        this.volume = volume;
    }

    @Generated
    public void setPages(String pages) {
        this.pages = pages;
    }

    @Generated
    public void setParagraph(String paragraph) {
        this.paragraph = paragraph;
    }

    @Generated
    public void setPublication(InputPublicationDto publication) {
        this.publication = publication;
    }

    @Generated
    public void setAuthors(List<InputAuthorDto> authors) {
        this.authors = authors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputManualReferenceDto)) {
            return false;
        }
        InputManualReferenceDto other = (InputManualReferenceDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$journalOrConference = this.getJournalOrConference();
        String other$journalOrConference = other.getJournalOrConference();
        if (this$journalOrConference == null ? other$journalOrConference != null : !this$journalOrConference.equals(other$journalOrConference)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$volume = this.getVolume();
        String other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
            return false;
        }
        String this$pages = this.getPages();
        String other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !this$pages.equals(other$pages)) {
            return false;
        }
        String this$paragraph = this.getParagraph();
        String other$paragraph = other.getParagraph();
        if (this$paragraph == null ? other$paragraph != null : !this$paragraph.equals(other$paragraph)) {
            return false;
        }
        InputPublicationDto this$publication = this.getPublication();
        InputPublicationDto other$publication = other.getPublication();
        if (this$publication == null ? other$publication != null : !this$publication.equals(other$publication)) {
            return false;
        }
        List this$authors = this.getAuthors();
        List other$authors = other.getAuthors();
        return !(this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputManualReferenceDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $journalOrConference = this.getJournalOrConference();
        result = result * 59 + ($journalOrConference == null ? 43 : $journalOrConference.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : $volume.hashCode());
        String $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : $pages.hashCode());
        String $paragraph = this.getParagraph();
        result = result * 59 + ($paragraph == null ? 43 : $paragraph.hashCode());
        InputPublicationDto $publication = this.getPublication();
        result = result * 59 + ($publication == null ? 43 : $publication.hashCode());
        List $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputManualReferenceDto(title=" + this.getTitle() + ", journalOrConference=" + this.getJournalOrConference() + ", url=" + this.getUrl() + ", volume=" + this.getVolume() + ", pages=" + this.getPages() + ", paragraph=" + this.getParagraph() + ", publication=" + String.valueOf(this.getPublication()) + ", authors=" + String.valueOf(this.getAuthors()) + ")";
    }

    @Generated
    public InputManualReferenceDto(String title, String journalOrConference, String url, String volume, String pages, String paragraph, InputPublicationDto publication, List<InputAuthorDto> authors) {
        this.title = title;
        this.journalOrConference = journalOrConference;
        this.url = url;
        this.volume = volume;
        this.pages = pages;
        this.paragraph = paragraph;
        this.publication = publication;
        this.authors = authors;
    }
}

