/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputCVDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserPreferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputWorkingLocationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="InputUpdateUserProfile", description="DTO for updating a userprofile")
public class InputUpdateUserProfileDto {
    @Schema(description="Link of the image of user", example="https://imageLink")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String imageUrl;
    @Schema(description="CV details of the user")
    @Valid
    private InputCVDto cv;
    @Schema(description="ORCID identifier of the user", example="0000-0002-1825-0097")
    private String orcid;
    @Schema(description="Whether the user is open to collaboration", example="false")
    private boolean openToCollaboration;
    @Schema(description="Whether the user's email is publicly visible", example="true")
    private boolean showPublicEmail;
    @Schema(description="Personal website URL", example="https://johndoe.example.com")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String personalWebsite;
    @Schema(description="LinkedIn profile URL", example="https://linkedin.com/in/johndoe")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String linkedinProfile;
    @Schema(description="Social profile URL (e.g., GitHub)", example="https://github.com/johndoe")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String socialProfile;
    @Schema(description="Short biography of the user", example="Ricercatore Legge 210/10 a tempo indeterminato")
    @Size(max=1000, message="Bio must be less than 1000 characters")
    private @Size(max=1000, message="Bio must be less than 1000 characters") String shortBio;
    @Schema(description="User's working location details")
    @Valid
    private InputWorkingLocationDto workingLocation;
    @Schema(description="Organization affiliation", example="Stanford University")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String organizationAffiliation;
    @Schema(description="Scientific Disciplinary Sectors", example="[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;
    @Schema(description="Areas of Expertise")
    @Valid
    private List<InputExpertiseDto> expertises;
    @Schema(description="List of references")
    @Valid
    private InputReferenceDto references;
    @Schema(description="User preferred language", example="EN")
    @NotBlank
    String language;
    @Schema(description="Whether the user profile is private or public", example="false")
    private boolean publicProfile;
    @Schema(description=" thematic interests of user", example="[\"Physics\", \"Maths\"]")
    private List<String> interests;
    @Schema(description="User email consent to receive messages", example="true")
    private boolean emailConsent;
    @Schema(description="User preferences")
    @Valid
    private InputUserPreferenceDto preferences;

    @Generated
    public static InputUpdateUserProfileDtoBuilder builder() {
        return new InputUpdateUserProfileDtoBuilder();
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public InputCVDto getCv() {
        return this.cv;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public boolean isOpenToCollaboration() {
        return this.openToCollaboration;
    }

    @Generated
    public boolean isShowPublicEmail() {
        return this.showPublicEmail;
    }

    @Generated
    public String getPersonalWebsite() {
        return this.personalWebsite;
    }

    @Generated
    public String getLinkedinProfile() {
        return this.linkedinProfile;
    }

    @Generated
    public String getSocialProfile() {
        return this.socialProfile;
    }

    @Generated
    public String getShortBio() {
        return this.shortBio;
    }

    @Generated
    public InputWorkingLocationDto getWorkingLocation() {
        return this.workingLocation;
    }

    @Generated
    public String getOrganizationAffiliation() {
        return this.organizationAffiliation;
    }

    @Generated
    public List<String> getSsd() {
        return this.ssd;
    }

    @Generated
    public List<InputExpertiseDto> getExpertises() {
        return this.expertises;
    }

    @Generated
    public InputReferenceDto getReferences() {
        return this.references;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isPublicProfile() {
        return this.publicProfile;
    }

    @Generated
    public List<String> getInterests() {
        return this.interests;
    }

    @Generated
    public boolean isEmailConsent() {
        return this.emailConsent;
    }

    @Generated
    public InputUserPreferenceDto getPreferences() {
        return this.preferences;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setCv(InputCVDto cv) {
        this.cv = cv;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setOpenToCollaboration(boolean openToCollaboration) {
        this.openToCollaboration = openToCollaboration;
    }

    @Generated
    public void setShowPublicEmail(boolean showPublicEmail) {
        this.showPublicEmail = showPublicEmail;
    }

    @Generated
    public void setPersonalWebsite(String personalWebsite) {
        this.personalWebsite = personalWebsite;
    }

    @Generated
    public void setLinkedinProfile(String linkedinProfile) {
        this.linkedinProfile = linkedinProfile;
    }

    @Generated
    public void setSocialProfile(String socialProfile) {
        this.socialProfile = socialProfile;
    }

    @Generated
    public void setShortBio(String shortBio) {
        this.shortBio = shortBio;
    }

    @Generated
    public void setWorkingLocation(InputWorkingLocationDto workingLocation) {
        this.workingLocation = workingLocation;
    }

    @Generated
    public void setOrganizationAffiliation(String organizationAffiliation) {
        this.organizationAffiliation = organizationAffiliation;
    }

    @Generated
    public void setSsd(List<String> ssd) {
        this.ssd = ssd;
    }

    @Generated
    public void setExpertises(List<InputExpertiseDto> expertises) {
        this.expertises = expertises;
    }

    @Generated
    public void setReferences(InputReferenceDto references) {
        this.references = references;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setPublicProfile(boolean publicProfile) {
        this.publicProfile = publicProfile;
    }

    @Generated
    public void setInterests(List<String> interests) {
        this.interests = interests;
    }

    @Generated
    public void setEmailConsent(boolean emailConsent) {
        this.emailConsent = emailConsent;
    }

    @Generated
    public void setPreferences(InputUserPreferenceDto preferences) {
        this.preferences = preferences;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputUpdateUserProfileDto)) {
            return false;
        }
        InputUpdateUserProfileDto other = (InputUpdateUserProfileDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isOpenToCollaboration() != other.isOpenToCollaboration()) {
            return false;
        }
        if (this.isShowPublicEmail() != other.isShowPublicEmail()) {
            return false;
        }
        if (this.isPublicProfile() != other.isPublicProfile()) {
            return false;
        }
        if (this.isEmailConsent() != other.isEmailConsent()) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        InputCVDto this$cv = this.getCv();
        InputCVDto other$cv = other.getCv();
        if (this$cv == null ? other$cv != null : !this$cv.equals(other$cv)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$personalWebsite = this.getPersonalWebsite();
        String other$personalWebsite = other.getPersonalWebsite();
        if (this$personalWebsite == null ? other$personalWebsite != null : !this$personalWebsite.equals(other$personalWebsite)) {
            return false;
        }
        String this$linkedinProfile = this.getLinkedinProfile();
        String other$linkedinProfile = other.getLinkedinProfile();
        if (this$linkedinProfile == null ? other$linkedinProfile != null : !this$linkedinProfile.equals(other$linkedinProfile)) {
            return false;
        }
        String this$socialProfile = this.getSocialProfile();
        String other$socialProfile = other.getSocialProfile();
        if (this$socialProfile == null ? other$socialProfile != null : !this$socialProfile.equals(other$socialProfile)) {
            return false;
        }
        String this$shortBio = this.getShortBio();
        String other$shortBio = other.getShortBio();
        if (this$shortBio == null ? other$shortBio != null : !this$shortBio.equals(other$shortBio)) {
            return false;
        }
        InputWorkingLocationDto this$workingLocation = this.getWorkingLocation();
        InputWorkingLocationDto other$workingLocation = other.getWorkingLocation();
        if (this$workingLocation == null ? other$workingLocation != null : !this$workingLocation.equals(other$workingLocation)) {
            return false;
        }
        String this$organizationAffiliation = this.getOrganizationAffiliation();
        String other$organizationAffiliation = other.getOrganizationAffiliation();
        if (this$organizationAffiliation == null ? other$organizationAffiliation != null : !this$organizationAffiliation.equals(other$organizationAffiliation)) {
            return false;
        }
        List this$ssd = this.getSsd();
        List other$ssd = other.getSsd();
        if (this$ssd == null ? other$ssd != null : !((Object)this$ssd).equals(other$ssd)) {
            return false;
        }
        List this$expertises = this.getExpertises();
        List other$expertises = other.getExpertises();
        if (this$expertises == null ? other$expertises != null : !((Object)this$expertises).equals(other$expertises)) {
            return false;
        }
        InputReferenceDto this$references = this.getReferences();
        InputReferenceDto other$references = other.getReferences();
        if (this$references == null ? other$references != null : !this$references.equals(other$references)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        List this$interests = this.getInterests();
        List other$interests = other.getInterests();
        if (this$interests == null ? other$interests != null : !((Object)this$interests).equals(other$interests)) {
            return false;
        }
        InputUserPreferenceDto this$preferences = this.getPreferences();
        InputUserPreferenceDto other$preferences = other.getPreferences();
        return !(this$preferences == null ? other$preferences != null : !this$preferences.equals(other$preferences));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputUpdateUserProfileDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOpenToCollaboration() ? 79 : 97);
        result = result * 59 + (this.isShowPublicEmail() ? 79 : 97);
        result = result * 59 + (this.isPublicProfile() ? 79 : 97);
        result = result * 59 + (this.isEmailConsent() ? 79 : 97);
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        InputCVDto $cv = this.getCv();
        result = result * 59 + ($cv == null ? 43 : $cv.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $personalWebsite = this.getPersonalWebsite();
        result = result * 59 + ($personalWebsite == null ? 43 : $personalWebsite.hashCode());
        String $linkedinProfile = this.getLinkedinProfile();
        result = result * 59 + ($linkedinProfile == null ? 43 : $linkedinProfile.hashCode());
        String $socialProfile = this.getSocialProfile();
        result = result * 59 + ($socialProfile == null ? 43 : $socialProfile.hashCode());
        String $shortBio = this.getShortBio();
        result = result * 59 + ($shortBio == null ? 43 : $shortBio.hashCode());
        InputWorkingLocationDto $workingLocation = this.getWorkingLocation();
        result = result * 59 + ($workingLocation == null ? 43 : $workingLocation.hashCode());
        String $organizationAffiliation = this.getOrganizationAffiliation();
        result = result * 59 + ($organizationAffiliation == null ? 43 : $organizationAffiliation.hashCode());
        List $ssd = this.getSsd();
        result = result * 59 + ($ssd == null ? 43 : ((Object)$ssd).hashCode());
        List $expertises = this.getExpertises();
        result = result * 59 + ($expertises == null ? 43 : ((Object)$expertises).hashCode());
        InputReferenceDto $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : $references.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        List $interests = this.getInterests();
        result = result * 59 + ($interests == null ? 43 : ((Object)$interests).hashCode());
        InputUserPreferenceDto $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : $preferences.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputUpdateUserProfileDto(imageUrl=" + this.getImageUrl() + ", cv=" + String.valueOf(this.getCv()) + ", orcid=" + this.getOrcid() + ", openToCollaboration=" + this.isOpenToCollaboration() + ", showPublicEmail=" + this.isShowPublicEmail() + ", personalWebsite=" + this.getPersonalWebsite() + ", linkedinProfile=" + this.getLinkedinProfile() + ", socialProfile=" + this.getSocialProfile() + ", shortBio=" + this.getShortBio() + ", workingLocation=" + String.valueOf(this.getWorkingLocation()) + ", organizationAffiliation=" + this.getOrganizationAffiliation() + ", ssd=" + String.valueOf(this.getSsd()) + ", expertises=" + String.valueOf(this.getExpertises()) + ", references=" + String.valueOf(this.getReferences()) + ", language=" + this.getLanguage() + ", publicProfile=" + this.isPublicProfile() + ", interests=" + String.valueOf(this.getInterests()) + ", emailConsent=" + this.isEmailConsent() + ", preferences=" + String.valueOf(this.getPreferences()) + ")";
    }

    @Generated
    public InputUpdateUserProfileDto(String imageUrl, InputCVDto cv, String orcid, boolean openToCollaboration, boolean showPublicEmail, String personalWebsite, String linkedinProfile, String socialProfile, String shortBio, InputWorkingLocationDto workingLocation, String organizationAffiliation, List<String> ssd, List<InputExpertiseDto> expertises, InputReferenceDto references, String language, boolean publicProfile, List<String> interests, boolean emailConsent, InputUserPreferenceDto preferences) {
        this.imageUrl = imageUrl;
        this.cv = cv;
        this.orcid = orcid;
        this.openToCollaboration = openToCollaboration;
        this.showPublicEmail = showPublicEmail;
        this.personalWebsite = personalWebsite;
        this.linkedinProfile = linkedinProfile;
        this.socialProfile = socialProfile;
        this.shortBio = shortBio;
        this.workingLocation = workingLocation;
        this.organizationAffiliation = organizationAffiliation;
        this.ssd = ssd;
        this.expertises = expertises;
        this.references = references;
        this.language = language;
        this.publicProfile = publicProfile;
        this.interests = interests;
        this.emailConsent = emailConsent;
        this.preferences = preferences;
    }

    @Generated
    public InputUpdateUserProfileDto() {
    }
}

