/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ManualReferenceEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.AuthorMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ManualReferenceMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.PublicationMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManualReferenceMapperImpl
implements ManualReferenceMapper {
    @Autowired
    private AuthorMapper authorMapper;
    @Autowired
    private PublicationMapper publicationMapper;

    public ManualReferenceEntity toEntity(InputManualReferenceDto model) {
        if (model == null) {
            return null;
        }
        ManualReferenceEntity.ManualReferenceEntityBuilder manualReferenceEntity = ManualReferenceEntity.builder();
        manualReferenceEntity.title(model.getTitle());
        manualReferenceEntity.journalOrConference(model.getJournalOrConference());
        manualReferenceEntity.url(model.getUrl());
        manualReferenceEntity.volume(model.getVolume());
        manualReferenceEntity.pages(model.getPages());
        manualReferenceEntity.paragraph(model.getParagraph());
        manualReferenceEntity.authors(this.inputAuthorDtoListToAuthorEntityList(model.getAuthors()));
        manualReferenceEntity.publication(this.publicationMapper.toEntity(model.getPublication()));
        ManualReferenceEntity manualReferenceEntityResult = manualReferenceEntity.build();
        this.setAuthors(manualReferenceEntityResult);
        this.setPublication(manualReferenceEntityResult);
        return manualReferenceEntityResult;
    }

    public OutputManualReferenceDto toDto(ManualReferenceEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputManualReferenceDto.OutputManualReferenceDtoBuilder outputManualReferenceDto = OutputManualReferenceDto.builder();
        outputManualReferenceDto.title(entity.getTitle());
        outputManualReferenceDto.journalOrConference(entity.getJournalOrConference());
        outputManualReferenceDto.url(entity.getUrl());
        outputManualReferenceDto.volume(entity.getVolume());
        outputManualReferenceDto.pages(entity.getPages());
        outputManualReferenceDto.paragraph(entity.getParagraph());
        outputManualReferenceDto.publication(this.publicationMapper.toDto(entity.getPublication()));
        outputManualReferenceDto.authors(this.authorEntityListToOutputAuthorDtoList(entity.getAuthors()));
        return outputManualReferenceDto.build();
    }

    protected List<AuthorEntity> inputAuthorDtoListToAuthorEntityList(List<InputAuthorDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AuthorEntity> list1 = new ArrayList<AuthorEntity>(list.size());
        for (InputAuthorDto inputAuthorDto : list) {
            list1.add(this.authorMapper.toEntity(inputAuthorDto));
        }
        return list1;
    }

    protected OutputAuthorDto authorEntityToOutputAuthorDto(AuthorEntity authorEntity) {
        if (authorEntity == null) {
            return null;
        }
        OutputAuthorDto.OutputAuthorDtoBuilder outputAuthorDto = OutputAuthorDto.builder();
        outputAuthorDto.firstName(authorEntity.getFirstName());
        outputAuthorDto.lastName(authorEntity.getLastName());
        outputAuthorDto.email(authorEntity.getEmail());
        outputAuthorDto.orcid(authorEntity.getOrcid());
        return outputAuthorDto.build();
    }

    protected List<OutputAuthorDto> authorEntityListToOutputAuthorDtoList(List<AuthorEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputAuthorDto> list1 = new ArrayList<OutputAuthorDto>(list.size());
        for (AuthorEntity authorEntity : list) {
            list1.add(this.authorEntityToOutputAuthorDto(authorEntity));
        }
        return list1;
    }
}

