/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="expertise")
public class ExpertiseEntity
extends AbstractUUIDEntity {
    @ManyToOne
    @JoinColumn(name="user_profile_id", nullable=false)
    private UserProfileEntity userProfile;
    @Column(name="label_id")
    private UUID labelId;
    @Column(name="display_name")
    private String displayName;
    @Column(name="endorsement_count")
    private Integer endorsementCount;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="expertise")
    @OrderBy(value="creationTime ASC")
    private List<EndorsementEntity> endorsements;
    @Column(name="expertise_order", nullable=false)
    private long expertiseOrder;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now();
    }

    public void incrementEndorsements() {
        if (this.endorsementCount == null) {
            this.endorsementCount = 0;
        }
        Integer n = this.endorsementCount;
        this.endorsementCount = this.endorsementCount + 1;
    }

    public void decrementEndorsements() {
        if (this.endorsementCount > 0) {
            Integer n = this.endorsementCount;
            this.endorsementCount = this.endorsementCount - 1;
        }
    }

    @Generated
    protected ExpertiseEntity(ExpertiseEntityBuilder<?, ?> b) {
        super(b);
        this.userProfile = b.userProfile;
        this.labelId = b.labelId;
        this.displayName = b.displayName;
        this.endorsementCount = b.endorsementCount;
        this.endorsements = b.endorsements;
        this.expertiseOrder = b.expertiseOrder;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static ExpertiseEntityBuilder<?, ?> builder() {
        return new ExpertiseEntityBuilderImpl();
    }

    @Generated
    public UserProfileEntity getUserProfile() {
        return this.userProfile;
    }

    @Generated
    public UUID getLabelId() {
        return this.labelId;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Integer getEndorsementCount() {
        return this.endorsementCount;
    }

    @Generated
    public List<EndorsementEntity> getEndorsements() {
        return this.endorsements;
    }

    @Generated
    public long getExpertiseOrder() {
        return this.expertiseOrder;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUserProfile(UserProfileEntity userProfile) {
        this.userProfile = userProfile;
    }

    @Generated
    public void setLabelId(UUID labelId) {
        this.labelId = labelId;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setEndorsementCount(Integer endorsementCount) {
        this.endorsementCount = endorsementCount;
    }

    @Generated
    public void setEndorsements(List<EndorsementEntity> endorsements) {
        this.endorsements = endorsements;
    }

    @Generated
    public void setExpertiseOrder(long expertiseOrder) {
        this.expertiseOrder = expertiseOrder;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ExpertiseEntity(labelId=" + String.valueOf(this.getLabelId()) + ", displayName=" + this.getDisplayName() + ", endorsementCount=" + this.getEndorsementCount() + ", expertiseOrder=" + this.getExpertiseOrder() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpertiseEntity)) {
            return false;
        }
        ExpertiseEntity other = (ExpertiseEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getExpertiseOrder() != other.getExpertiseOrder()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Integer this$endorsementCount = this.getEndorsementCount();
        Integer other$endorsementCount = other.getEndorsementCount();
        if (this$endorsementCount == null ? other$endorsementCount != null : !((Object)this$endorsementCount).equals(other$endorsementCount)) {
            return false;
        }
        UUID this$labelId = this.getLabelId();
        UUID other$labelId = other.getLabelId();
        if (this$labelId == null ? other$labelId != null : !((Object)this$labelId).equals(other$labelId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List this$endorsements = this.getEndorsements();
        List other$endorsements = other.getEndorsements();
        if (this$endorsements == null ? other$endorsements != null : !((Object)this$endorsements).equals(other$endorsements)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpertiseEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $expertiseOrder = this.getExpertiseOrder();
        result = result * 59 + (int)($expertiseOrder >>> 32 ^ $expertiseOrder);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Integer $endorsementCount = this.getEndorsementCount();
        result = result * 59 + ($endorsementCount == null ? 43 : ((Object)$endorsementCount).hashCode());
        UUID $labelId = this.getLabelId();
        result = result * 59 + ($labelId == null ? 43 : ((Object)$labelId).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List $endorsements = this.getEndorsements();
        result = result * 59 + ($endorsements == null ? 43 : ((Object)$endorsements).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ExpertiseEntity() {
    }
}

