/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAddProjectToUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByInterestsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByPrincipalsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByTokenInfoDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputRemoveProjectFromUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileFolderDetailsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.validation.annotation.ValidInputCreateOrUpdateUserProfileDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="UserProfile", description="The UserProfile API: it provides endpoints for retrieving, creating, updating, and deleting UserProfiles.")
@SecurityRequirement(name="BearerAuth")
public interface UserProfileApi {
    @Operation(summary="find all UserProfiles", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/profiles"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputUserProfileDto> findAll(@RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var1, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var2, @RequestParam(name="sort", defaultValue="id", required=false) String var3, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var4);

    @Operation(summary="find userprofile by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/profile"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUserProfileDto findById();

    @Operation(summary="get userprofile by profileId", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/profiles/{profileId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUserProfileDto getById(@PathVariable(value="profileId") UUID var1);

    @Operation(summary="find user profiles by ids", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/profiles-by-ids"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputUserProfileDto> findAllByIds(@Valid @RequestBody InputFindUserProfilesByIdsDto var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="id", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="Perform user profile search for autocompletion and retrieve the results", description="Perform user profile search for autocompletion based on the terms provided and retrieve results")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/profiles/auto-complete"}, produces={"application/json"})
    public Page<OutputUserProfileAutoCompleteDto> getAutoCompletions(@NotNull @Size(min=3) @RequestParam(value="terms") @NotNull @Size(min=3) String var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="id", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="create userprofile for the authenticated user", responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="409", description="Already Exists", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PostMapping(value={"/profile"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputUserProfileDto create(@Valid @ValidInputCreateOrUpdateUserProfileDto @RequestBody InputUserProfileDto var1);

    @Operation(summary="update userprofile by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PutMapping(value={"/profile"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUserProfileDto updateById(@Valid @ValidInputCreateOrUpdateUserProfileDto @RequestBody InputUpdateUserProfileDto var1);

    @Operation(summary="find userprofile by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/profile/folder"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUserProfileFolderDetailsDto getUserProfileFolderId();

    @Operation(summary="patch user profile by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PatchMapping(value={"/profile"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPatchUserProfileDto patchUserProfile(@RequestBody InputPatchUserProfileDto var1);

    @Operation(summary="find user profiles by principals", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/profiles-by-principals"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputUserProfileDto> findAllByPrincipals(@Valid @RequestBody InputFindUserProfilesByPrincipalsDto var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="id", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="add project to userprofile for given ids", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/profiles/project"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputUserProfileDto> addProjectToUserProfiles(@Valid @RequestBody InputAddProjectToUserProfilesDto var1);

    @Operation(summary="removes project from userprofile for given ids", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/profiles/project"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputUserProfileDto> removeProjectFromUserProfiles(@Valid @RequestBody InputRemoveProjectFromUserProfilesDto var1);

    @Operation(summary="update project for existing userprofile for given ids", responses={@ApiResponse(responseCode="200", description="OK")})
    @PatchMapping(value={"/profiles/projects"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputUserProfileDto> patchUserProfileProject(@Valid @RequestBody InputPatchUserProfileProjectDto var1);

    @Operation(summary="find user profiles by mixed info carried by the token", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/profiles-by-token-infos"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputUserProfileDto> findAllByTokenInfo(@Valid @RequestBody InputFindUserProfilesByTokenInfoDto var1);

    @Operation(summary="activate a user profile by ID", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})}, hidden=true)
    @PostMapping(value={"/profile/activate"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void activate();

    @Operation(summary="deactivate a user profile by ID", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})}, hidden=true)
    @DeleteMapping(value={"/profile/activate"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deactivate();

    @Operation(summary="find user profiles by matching interests", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/profile-ids-by-interests"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<UUID> findMatchingInterests(@Valid @RequestBody InputFindUserProfilesByInterestsDto var1);
}

