/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ProjectEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="project")
public class ProjectEntity
extends AbstractUUIDEntity {
    @ManyToOne
    @JoinColumn(name="user_profile_id", nullable=false)
    private UserProfileEntity userProfile;
    @Column(name="project_id")
    private UUID projectId;
    @Column(name="display_name")
    private String displayName;
    @Column(name="wp")
    private String wp;
    @Column(name="root_project_id")
    private UUID rootProjectId;
    @Column(name="root_project_display_name")
    private String rootProjectDisplayName;
    @Column(name="wp_lead")
    private Boolean wpLead;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected ProjectEntity(ProjectEntityBuilder<?, ?> b) {
        super(b);
        this.userProfile = b.userProfile;
        this.projectId = b.projectId;
        this.displayName = b.displayName;
        this.wp = b.wp;
        this.rootProjectId = b.rootProjectId;
        this.rootProjectDisplayName = b.rootProjectDisplayName;
        this.wpLead = b.wpLead;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static ProjectEntityBuilder<?, ?> builder() {
        return new ProjectEntityBuilderImpl();
    }

    @Generated
    public UserProfileEntity getUserProfile() {
        return this.userProfile;
    }

    @Generated
    public UUID getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getWp() {
        return this.wp;
    }

    @Generated
    public UUID getRootProjectId() {
        return this.rootProjectId;
    }

    @Generated
    public String getRootProjectDisplayName() {
        return this.rootProjectDisplayName;
    }

    @Generated
    public Boolean getWpLead() {
        return this.wpLead;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUserProfile(UserProfileEntity userProfile) {
        this.userProfile = userProfile;
    }

    @Generated
    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setWp(String wp) {
        this.wp = wp;
    }

    @Generated
    public void setRootProjectId(UUID rootProjectId) {
        this.rootProjectId = rootProjectId;
    }

    @Generated
    public void setRootProjectDisplayName(String rootProjectDisplayName) {
        this.rootProjectDisplayName = rootProjectDisplayName;
    }

    @Generated
    public void setWpLead(Boolean wpLead) {
        this.wpLead = wpLead;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ProjectEntity(userProfile=" + String.valueOf(this.getUserProfile()) + ", projectId=" + String.valueOf(this.getProjectId()) + ", displayName=" + this.getDisplayName() + ", wp=" + this.getWp() + ", rootProjectId=" + String.valueOf(this.getRootProjectId()) + ", rootProjectDisplayName=" + this.getRootProjectDisplayName() + ", wpLead=" + this.getWpLead() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectEntity)) {
            return false;
        }
        ProjectEntity other = (ProjectEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$wpLead = this.getWpLead();
        Boolean other$wpLead = other.getWpLead();
        if (this$wpLead == null ? other$wpLead != null : !((Object)this$wpLead).equals(other$wpLead)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$wp = this.getWp();
        String other$wp = other.getWp();
        if (this$wp == null ? other$wp != null : !this$wp.equals(other$wp)) {
            return false;
        }
        UUID this$rootProjectId = this.getRootProjectId();
        UUID other$rootProjectId = other.getRootProjectId();
        if (this$rootProjectId == null ? other$rootProjectId != null : !((Object)this$rootProjectId).equals(other$rootProjectId)) {
            return false;
        }
        String this$rootProjectDisplayName = this.getRootProjectDisplayName();
        String other$rootProjectDisplayName = other.getRootProjectDisplayName();
        if (this$rootProjectDisplayName == null ? other$rootProjectDisplayName != null : !this$rootProjectDisplayName.equals(other$rootProjectDisplayName)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Boolean $wpLead = this.getWpLead();
        result = result * 59 + ($wpLead == null ? 43 : ((Object)$wpLead).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $wp = this.getWp();
        result = result * 59 + ($wp == null ? 43 : $wp.hashCode());
        UUID $rootProjectId = this.getRootProjectId();
        result = result * 59 + ($rootProjectId == null ? 43 : ((Object)$rootProjectId).hashCode());
        String $rootProjectDisplayName = this.getRootProjectDisplayName();
        result = result * 59 + ($rootProjectDisplayName == null ? 43 : $rootProjectDisplayName.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ProjectEntity() {
    }
}

