/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.service.impl;

import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoConfigurationProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoOauthProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.OutputZenodoConfigDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.mapper.ExportRequestMapper;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.zenodo.bs.service.ZenodoService;
import com.finconsgroup.itserr.marketplace.zenodo.bs.validation.CreateExportRequestValidator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultZenodoService
implements ZenodoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultZenodoService.class);
    private final ZenodoConfigurationProperties zenodoConfigurationProperties;
    private final CreateExportRequestValidator createExportRequestValidator;
    private final ExportRequestMapper exportRequestMapper;
    private final EventProducer eventProducer;

    public OutputZenodoConfigDto getConfig() {
        ZenodoOauthProperties oauth = this.zenodoConfigurationProperties.getOauth();
        return OutputZenodoConfigDto.builder().host(this.zenodoConfigurationProperties.getHost()).clientId(oauth.getClientId()).scopes(oauth.getScopes()).build();
    }

    public void createExport(@NonNull InputCreateZenodoExportDto request) {
        CreateExportRequestValidator.ValidatedRequest data = this.createExportRequestValidator.validate(request);
        this.eventProducer.publishExportRequestCreatedEvent(this.exportRequestMapper.toMessageDto(data));
    }

    @Generated
    public DefaultZenodoService(ZenodoConfigurationProperties zenodoConfigurationProperties, CreateExportRequestValidator createExportRequestValidator, ExportRequestMapper exportRequestMapper, EventProducer eventProducer) {
        this.zenodoConfigurationProperties = zenodoConfigurationProperties;
        this.createExportRequestValidator = createExportRequestValidator;
        this.exportRequestMapper = exportRequestMapper;
        this.eventProducer = eventProducer;
    }
}

