/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.validation;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto.OutputCatalogItemDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.OutputOauthTokenDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.NoSourceItemIdException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.NoZenodoAuthCodeException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.NoZenodoRedirectUriException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.validation.CatalogItemValidator;
import com.finconsgroup.itserr.marketplace.zenodo.bs.validation.CreateExportRequestValidator;
import com.finconsgroup.itserr.marketplace.zenodo.bs.zenodo.ZenodoAuthenticator;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CreateExportRequestValidator {
    private final ZenodoAuthenticator zenodoAuthenticator;
    private final CatalogItemValidator catalogItemValidator;

    public ValidatedRequest validate(InputCreateZenodoExportDto request) {
        InputCreateZenodoExportDto.ZenodoDto zenodo = Optional.ofNullable(request).map(InputCreateZenodoExportDto::getZenodo).orElseThrow(NoZenodoAuthCodeException::new);
        String authCode = Optional.of(zenodo).map(InputCreateZenodoExportDto.ZenodoDto::getAuthCode).filter(StringUtils::isNotBlank).orElseThrow(NoZenodoAuthCodeException::new);
        URI redirectUri = Optional.of(zenodo).map(InputCreateZenodoExportDto.ZenodoDto::getRedirectUri).orElseThrow(NoZenodoRedirectUriException::new);
        String catalogItemId = Optional.of(request).map(InputCreateZenodoExportDto::getSource).map(InputCreateZenodoExportDto.SourceDto::getId).filter(StringUtils::isNotBlank).orElseThrow(NoSourceItemIdException::new);
        OutputOauthTokenDto token = this.zenodoAuthenticator.getToken(authCode, redirectUri);
        OutputCatalogItemDto catalogItem = this.catalogItemValidator.validate(catalogItemId);
        return new ValidatedRequest(request, token, catalogItem);
    }

    @Generated
    public CreateExportRequestValidator(ZenodoAuthenticator zenodoAuthenticator, CatalogItemValidator catalogItemValidator) {
        this.zenodoAuthenticator = zenodoAuthenticator;
        this.catalogItemValidator = catalogItemValidator;
    }
}

