/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.server.dao.postgres.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.util.PGobject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class ConfigurationDAO
implements GenericConfigurationDAO {
    private static final Log log = LogFactory.getLog(ConfigurationDAO.class);
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    public List<SensorConfiguration> listConfigurations(String scenario) {
        log.info((Object)("List configurations for scenario " + scenario));
        String query = "SELECT params FROM configurations WHERE params->>'monitoringScenario' = ?";
        return this.queryForConfigurationList(query, new Object[]{scenario});
    }

    public SensorConfiguration getConfiguration(String scenario, String configurationName) {
        log.info((Object)("Get configurations " + scenario + "/" + configurationName));
        String query = "SELECT params FROM configurations WHERE params->>'monitoringScenario' = ? AND name = ?";
        return (SensorConfiguration)this.queryForConfigurationList(query, new Object[]{scenario, configurationName}).get(0);
    }

    private List<SensorConfiguration> queryForConfigurationList(String query, Object ... queryParams) {
        ArrayList results = Lists.newArrayList();
        List rows = this.jdbcTemplate.queryForList(query, queryParams);
        for (Map row : rows) {
            results.add(new SensorConfiguration(this.PGJsonToMap(row.get("params"))));
        }
        return results;
    }

    private Map<String, Object> PGJsonToMap(Object obj) {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        if (obj != null) {
            return (Map)new Gson().fromJson(((PGobject)obj).getValue(), listType);
        }
        return new HashMap<String, Object>();
    }

    public List<String> listMetrics(String scenario) {
        List queryForList = this.jdbcTemplate.queryForList("SELECT DISTINCT json_object_keys(params->'querySet') AS m FROM configurations WHERE params->>'monitoringScenario'=? ORDER BY m ASC ;", String.class, new Object[]{scenario});
        return queryForList;
    }

    public List<String> listLabelNames(String scenario, String metric) {
        List queryForList = this.jdbcTemplate.queryForList("SELECT DISTINCT json_object_keys(params->'labels') AS l FROM configurations WHERE params->>'monitoringScenario'=? AND params->'querySet'->>? != '' ORDER BY l ASC;", String.class, new Object[]{scenario, metric});
        return queryForList;
    }

    public List<String> listLabelValues(String scenario, String metric, String labenName) {
        List queryForList = this.jdbcTemplate.queryForList("SELECT DISTINCT params->'labels'->>? AS v FROM configurations WHERE params->>'monitoringScenario'=? AND params->'querySet'->>? != '' ORDER BY v ASC;", String.class, new Object[]{labenName, scenario, metric});
        return queryForList;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

