/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.configurations.rest;

import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/configurations"})
public class ConfigurationController {
    @Autowired
    private GenericConfigurationDAO confDao;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SensorConfiguration> ListConfigurationsByScenario(@PathVariable String scenario) {
        List listConfigurations = this.confDao.listConfigurations(scenario);
        return listConfigurations;
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public SensorConfiguration getConfigurationByName(@PathVariable String scenario, @PathVariable String name) {
        SensorConfiguration configuration = this.confDao.getConfiguration(scenario, name);
        return configuration;
    }
}

