/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.server.dao.postgres.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.monitoring.controls.Control;
import eu.dnetlib.monitoring.controls.Selector;
import eu.dnetlib.monitoring.server.dao.GenericControlDAO;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.util.PGobject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.support.TransactionTemplate;

public class ControlDAO
implements GenericControlDAO {
    private static final Log log = LogFactory.getLog(ControlDAO.class);
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    public int create(Control control) {
        String query = "INSERT INTO controls(name, monitoringscenario, selectors, analyzerclass, status, lastmodified) VALUES (?, ?, ?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update((PreparedStatementCreator)new /* Unavailable Anonymous Inner Class!! */, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    public int update(Control control) {
        log.debug((Object)("Update control " + control.getId()));
        String query = "UPDATE controls SET (name, monitoringscenario, selectors, analyzerclass, status, lastmodified) = (?, ?, ?, ?, ?, ?) WHERE id = ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update((PreparedStatementCreator)new /* Unavailable Anonymous Inner Class!! */, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    public void delete(int id) {
        log.debug((Object)("Delete control " + id));
        String query = "DELETE FROM controls WHERE id = ?";
        this.jdbcTemplate.update("DELETE FROM controls WHERE id = ?", new Object[]{id});
    }

    public Control get(String scenario, String controlName) {
        log.debug((Object)("Get control " + controlName + " from scenario " + scenario));
        String query = "SELECT * FROM controls WHERE monitoringscenario = ? and name = ?";
        return (Control)this.queryForControlList(query, new Object[]{scenario, controlName}).get(0);
    }

    public List<Control> listControls(String scenario) {
        log.debug((Object)("List controls in scenario " + scenario));
        String query = "SELECT * FROM controls WHERE monitoringscenario = ?";
        return this.queryForControlList(query, new Object[]{scenario});
    }

    public List<Control> listControls(String scenario, String metric) {
        log.debug((Object)("List controls in scenario " + scenario + " for metric " + metric));
        String query = "SELECT * FROM controls c1 WHERE monitoringscenario = ? AND ? in (SELECT json_array_elements(selectors)->>'metric' FROM controls c2 WHERE c1.id = c2.id);";
        return this.queryForControlList(query, new Object[]{scenario, metric});
    }

    public List<Control> listActiveControls(String scenario) {
        log.debug((Object)("List active controls in scenario " + scenario));
        String query = "SELECT * FROM controls WHERE status = 'active' AND monitoringscenario = ?";
        return this.queryForControlList(query, new Object[]{scenario});
    }

    public List<Control> listActiveControls(String scenario, String metric) {
        log.debug((Object)("List active controls in scenario " + scenario + " for metric " + metric));
        String query = "SELECT * FROM controls c1 WHERE status = 'active' AND monitoringscenario = ? AND ? in (SELECT json_array_elements(selectors)->>'metric' FROM controls c2 WHERE c1.id = c2.id);";
        return this.queryForControlList(query, new Object[]{scenario, metric});
    }

    private List<Control> queryForControlList(String query, Object ... params) {
        ArrayList results = Lists.newArrayList();
        List rows = this.jdbcTemplate.queryForList(query, params);
        for (Map row : rows) {
            Control ctrl = new Control();
            ctrl.setId(((Integer)row.get("id")).intValue());
            ctrl.setName((String)row.get("Name"));
            ctrl.setMonitoringScenario((String)row.get("monitoringScenario"));
            ctrl.setAnalyzerClass((String)row.get("analyzerclass"));
            ctrl.setSelectors(this.pgJsonToList(row.get("selectors")));
            ctrl.setStatus((String)row.get("status"));
            ctrl.setLastModified(((Timestamp)row.get("lastmodified")).getTime());
            results.add(ctrl);
        }
        return results;
    }

    private PGobject listToPGJson(List list) throws SQLException {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("json");
        jsonObject.setValue(new Gson().toJson((Object)list));
        return jsonObject;
    }

    private List<Selector> pgJsonToList(Object obj) {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        if (obj != null) {
            return (List)new Gson().fromJson(((PGobject)obj).getValue(), listType);
        }
        return new ArrayList<Selector>();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    static /* synthetic */ PGobject access$000(ControlDAO x0, List x1) throws SQLException {
        return x0.listToPGJson(x1);
    }
}

