package eu.dnetlib.monitoring.controls.analyzers.impl;

import eu.dnetlib.monitoring.controls.analyzers.Analyzer;
import eu.dnetlib.monitoring.model.Observation;

import java.util.List;

public class AboveThreshold extends Analyzer {

	@Override
	public boolean analyze(final List<Observation> observations) {
		for (Observation observation : observations) {
			if (observation.getLog() < 0.9)
				return false;
		}
		return true;
	}

	@Override
	public String getName() {
		return "Are equal";
	}

	@Override
	public String getDescription() {
		return "Works with 1+ selectors. Checks if ALL the provided points are equal.";
	}

}
