/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.controls.rest;

import eu.dnetlib.monitoring.controls.Control;
import eu.dnetlib.monitoring.server.dao.GenericControlDAO;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/controls"})
public class ControlController {
    private static final Log log = LogFactory.getLog(ControlController.class);
    @Autowired
    private GenericControlDAO controlDao;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public List<Control> listControls(@PathVariable String scenario) {
        log.info((Object)String.format("List controls for scenario (%s)", scenario));
        return this.controlDao.listControls(scenario);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public int createControl(@PathVariable String scenario, @RequestBody Control control) {
        int controlId = this.controlDao.create(control);
        log.info((Object)("Created control - Id: " + controlId));
        return controlId;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PUT})
    public int updateControl(@PathVariable String scenario, @RequestBody Control control) {
        int controlId = this.controlDao.update(control);
        log.info((Object)("Updated control - Id: " + controlId));
        return controlId;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{controlId}"})
    public String deleteControl(@PathVariable String scenario, @PathVariable String controlId) {
        log.info((Object)("Delete control - Id: " + controlId));
        this.controlDao.delete(Integer.valueOf(controlId).intValue());
        return controlId;
    }
}

