/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.controls.analyzers.impl;

import eu.dnetlib.monitoring.controls.analyzers.Analyzer;
import eu.dnetlib.monitoring.model.Observation;
import java.util.List;

public class IsMonotonicIncreasing
extends Analyzer {
    public boolean analyze(List<Observation> observations) {
        if (observations.size() > 0) {
            Double pivot = observations.get(0).getLog();
            for (Observation o : observations) {
                if (o.getLog().compareTo(pivot) < 0) {
                    return false;
                }
                pivot = o.getLog();
            }
        }
        return true;
    }

    public String getName() {
        return "Is monotonic increasing";
    }

    public String getDescription() {
        return "Make sense for 1 selector only. Checks if the points are monotonic increasing.";
    }
}

