package eu.dnetlib.monitoring.controls.analyzers.rest;

import java.util.List;
import java.util.Set;

import com.google.common.collect.Lists;
import eu.dnetlib.monitoring.controls.analyzers.Analyzer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.Reflections;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/analyzers")
public class AnalyzerController {

	private static final Log log = LogFactory.getLog(AnalyzerController.class);

	@ResponseBody
	@RequestMapping(method = RequestMethod.GET)
	public List<Analyzer> listAnalyzers() throws InstantiationException, IllegalAccessException {
		log.info("Listing analyzers");
		List<Analyzer> list = Lists.newArrayList();
		Reflections reflections = new Reflections("eu.dnetlib.monitoring.controls.analyzers.impl");
		Set<Class<? extends Analyzer>> subTypes = reflections.getSubTypesOf(Analyzer.class);

		for (Class<? extends Analyzer> c : subTypes) {
			Analyzer a = c.newInstance();
			list.add(c.newInstance());
		}

		return list;
	}
}
