/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.server.dao.postgres.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.monitoring.model.Observation;
import eu.dnetlib.monitoring.server.dao.GenericStashDAO;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.util.PGobject;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class ObservationDAO
implements GenericStashDAO {
    private static final Log log = LogFactory.getLog(ObservationDAO.class);
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    public boolean create(Observation observation) {
        log.debug((Object)("Serving stash record from " + observation.getSensorType()));
        if (observation.getLog() == null) {
            return false;
        }
        try {
            this.jdbcTemplate.update("INSERT INTO logstash(TimeMarker, Metric, Labels, SensorType, SensorId, Log, MonitoringScenario) VALUES (?, ?, ?, ?, ?, ?, ?)", new Object[]{new Timestamp(observation.getTimestamp()), observation.getMetric(), this.MapToPGJson(observation.getLabels()), observation.getSensorType(), observation.getSensorId(), observation.getLog(), observation.getMonitoringScenario()});
        }
        catch (SQLException e) {
            log.error((Object)"Error during labels conversion", (Throwable)e);
            return false;
        }
        return true;
    }

    private PGobject MapToPGJson(Map map) throws SQLException {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("json");
        jsonObject.setValue(new Gson().toJson((Object)map));
        return jsonObject;
    }

    private Map PGJsonToMap(Object obj) {
        if (obj != null) {
            return (Map)new Gson().fromJson(((PGobject)obj).getValue(), Map.class);
        }
        return new HashMap();
    }

    public Observation getById(String id) {
        return null;
    }

    public List<Observation> findObservations(String scenario, String metric) {
        String query = "SELECT * FROM logstash WHERE monitoringscenario = ? AND metric = ?";
        return this.queryForObservationList(query, new Object[]{scenario, metric});
    }

    public List<Observation> findObservations(String scenario, String metric, String labelName) {
        String query = "SELECT * FROM logstash WHERE monitoringscenario = ? AND metric = ? AND labels ->> ? != ''";
        return this.queryForObservationList(query, new Object[]{scenario, metric, labelName});
    }

    public List<String> listMetrics(String scenario) {
        return this.jdbcTemplate.queryForList("SELECT DISTINCT metric FROM logstash WHERE monitoringscenario = '{s}' ORDER BY metric ASC;".replace("{s}", scenario), String.class);
    }

    public List<Observation> findKLastObservations(String scenario, String metric, int k) {
        String query = "SELECT * from logstash where monitoringscenario = ? AND metric = ? and timemarker in (SELECT DISTINCT timemarker FROM logstash ORDER BY timemarker DESC LIMIT ?) ORDER BY timemarker ASC";
        return this.queryForObservationList(query, new Object[]{scenario, metric, k});
    }

    public List<Observation> findKLastObservations(String scenario, String metric, String labelName, int k) {
        String query = "SELECT * FROM logstash WHERE monitoringscenario = ? AND metric = ? AND labels ->> ? != '' AND timemarker IN (SELECT DISTINCT timemarker FROM logstash ORDER BY timemarker DESC LIMIT ?) ORDER BY timemarker ASC";
        return this.queryForObservationList(query, new Object[]{scenario, metric, labelName, k});
    }

    public List<Observation> findKLastObservations(String scenario, String metric, String labelName, String labelVelue, int k) {
        String query = "SELECT * FROM logstash WHERE monitoringscenario = ? AND metric = ? AND labels ->> ? = ? AND timemarker IN (SELECT DISTINCT timemarker FROM logstash ORDER BY timemarker DESC LIMIT ?) ORDER BY timemarker ASC";
        return this.queryForObservationList(query, new Object[]{scenario, metric, labelName, labelVelue, k});
    }

    private List<Observation> queryForObservationList(String query, Object ... params) {
        ArrayList results = Lists.newArrayList();
        List rows = this.jdbcTemplate.queryForList(query, params);
        for (Map row : rows) {
            Observation obs = new Observation();
            obs.setTimestamp(((Timestamp)row.get("TimeMarker")).getTime());
            obs.setMetric((String)row.get("Metric"));
            obs.setLog((Double)row.get("Log"));
            obs.setSensorType((String)row.get("SensorType"));
            obs.setSensorId((String)row.get("SensorId"));
            obs.setLabels(this.PGJsonToMap(row.get("Labels")));
            obs.setMonitoringScenario((String)row.get("monitoringScenario"));
            results.add(obs);
        }
        return results;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Required
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Required
    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public int countObservations(String scenario) {
        return (Integer)this.jdbcTemplate.queryForObject("SELECT count(id) FROM logstash WHERE monitoringscenario = ?", Integer.class, new Object[]{scenario});
    }
}

