/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.tools.Enableable;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.enabling.tools.blackboard.BlackboardHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public abstract class AbstractBlackboardNotificationHandler<T extends BlackboardHandler>
implements NotificationHandler,
Enableable {
    private T blackboardHandler;
    private boolean enabled = true;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        if (!topic.contains("BODY.BLACKBOARD.LAST")) {
            return;
        }
        try {
            this.processJob(this.blackboardHandler.getJob((OpaqueResource)new StringOpaqueResource(profile)));
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract void processJob(BlackboardJob var1);

    public T getBlackboardHandler() {
        return this.blackboardHandler;
    }

    @Required
    public void setBlackboardHandler(T blackboardHandler) {
        this.blackboardHandler = blackboardHandler;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

