/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGenerator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGeneratorImpl;
import eu.dnetlib.enabling.tools.blackboard.ActionStatus;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardMessage;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;

public class BlackboardClientHandlerImpl
implements BlackboardClientHandler {
    private JaxbFactory<BlackboardMessage> messageFactory;
    private ServiceLocator<ISRegistryService> registryLocator;
    private UniqueIdentifierGenerator uuidGenerator = new UniqueIdentifierGeneratorImpl("bb-");

    @Override
    public void assign(BlackboardJob job) {
        this.checkJob(job);
        try {
            BlackboardJobImpl impl = (BlackboardJobImpl)job;
            ((ISRegistryService)this.registryLocator.getService()).addBlackBoardMessage(impl.getServiceId(), job.getId(), this.messageFactory.serialize((Object)impl.getMessage()));
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot register blackboard message", e);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("cannot serialize blackboard message", e);
        }
    }

    protected void checkJob(BlackboardJob job) {
        for (Map.Entry<String, String> param : job.getParameters().entrySet()) {
            if (param.getValue() != null) continue;
            throw new IllegalStateException("job parameter value cannot be null: " + param.getKey());
        }
    }

    @Override
    public void delete(BlackboardJob job) {
        try {
            BlackboardJobImpl impl = (BlackboardJobImpl)job;
            ((ISRegistryService)this.registryLocator.getService()).deleteBlackBoardMessage(impl.getServiceId(), job.getId());
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot delete blackboard message", e);
        }
    }

    @Override
    public BlackboardJob newJob(String serviceId) {
        BlackboardJobImpl job = new BlackboardJobImpl(serviceId, (BlackboardMessage)this.messageFactory.newInstance());
        job.setActionStatus(ActionStatus.ASSIGNED);
        job.getParameters().put("id", "");
        job.getParameters().put("error", "");
        job.setId(this.uuidGenerator.generateIdentifier());
        return job;
    }

    @Override
    public BlackboardJob getJob(OpaqueResource profile) {
        XPath xpa = XPathFactory.newInstance().newXPath();
        try {
            Element source = (Element)xpa.evaluate("/RESOURCE_PROFILE/BODY/BLACKBOARD/MESSAGE[@id = /RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_RESPONSE]", profile.asDom(), XPathConstants.NODE);
            if (source == null) {
                throw new IllegalStateException("cannot find last blackboard message in the service profile");
            }
            return new BlackboardJobImpl(profile.getResourceId(), (BlackboardMessage)this.messageFactory.parse((Source)new DOMSource(source)));
        }
        catch (JAXBException e) {
            throw new IllegalStateException("cannot parse blackboard message", e);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("cannot find last blackboard message in the service profile", e);
        }
    }

    public JaxbFactory<BlackboardMessage> getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(JaxbFactory<BlackboardMessage> messageFactory) {
        this.messageFactory = messageFactory;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public UniqueIdentifierGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UniqueIdentifierGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }
}

