/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation.inspector;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TransformatorMockInspector {
    private static final Log log = LogFactory.getLog(TransformatorMockInspector.class);
    @Resource(name="aggregatorJobScheduler")
    private Scheduler jobScheduler;
    @Resource(name="transformJob")
    private JobDetail transformJob;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    @RequestMapping(value={"/inspector/aggregatorFillRealData-transform.do"})
    public String fillRealData(@RequestParam(value="store") String dataSink, @RequestParam(value="hi") String hid, @RequestParam(value="name") String repoName, @RequestParam(value="delay") String delay) throws SchedulerException {
        HumanTime delta = HumanTime.eval((CharSequence)delay);
        long startTime = System.currentTimeMillis() + delta.getDelta();
        SimpleTrigger trigger = new SimpleTrigger("transformTrigger-" + UUID.randomUUID().toString(), null, new Date(startTime), null, 0, 0L);
        trigger.getJobDataMap().put("hid", hid);
        trigger.getJobDataMap().put("dataSink", dataSink);
        trigger.getJobDataMap().put("name", repoName);
        trigger.getJobDataMap().put("type", "transform");
        trigger.setJobName("transformJob");
        JobDetail tmp = this.jobScheduler.getJobDetail("transformJob", null);
        if (tmp == null) {
            log.fatal((Object)"reregistering job detail");
            this.jobScheduler.addJob(this.transformJob, true);
        }
        this.jobScheduler.scheduleJob((Trigger)trigger);
        return "redirect:hilist.do";
    }

    @RequestMapping(value={"/inspector/transformatorMock-transform.do"})
    public String transform(@RequestParam(value="id") String id) throws SchedulerException, ISLookUpDocumentNotFoundException, ISLookUpException {
        String dataSink = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + id + "']]/BODY/CONFIGURATION/DATA_SINK/string()");
        String repoName = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("let $repoId := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + id + "']]//REPOSITORY_SERVICE_IDENTIFIER/string() " + "return //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=$repoId]" + "/BODY/CONFIGURATION/OFFICIAL_NAME/string()");
        log.debug((Object)("\n\n dataSink: " + dataSink + "\n repoName: " + repoName));
        return "redirect:aggregatorFillRealData-transform.do?hi=" + id + "&store=" + dataSink + "&name=" + repoName + "&delay=";
    }
}

