<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	exclude-result-prefixes="datetime exslt oai oai_dc">
	
<xsl:output method="xml" indent="yes" />

<!-- TODO: apply conversion for dates and other fields (Sandro knows which) -->

<xsl:param name="repositoryName"/>
<xsl:param name="repositoryLink"/>
<xsl:param name="repositoryCountry"/>
<xsl:param name="repositoryInstitution"/>

<!-- let's copy everything, then we'll override behaviour -->
<xsl:template match="*">
	<xsl:copy> 
	<xsl:apply-templates select="@*|*|text()"/>
	</xsl:copy>
</xsl:template>

<!-- puts namespaces at the record element level instead of inner children-->
<xsl:template match="record">
<record>
<xsl:apply-templates select="@*|*"/>
</record>
</xsl:template>

<!--
puts in the header element any namespaces that are not in its parent (record), 
actually no namespace should be in the result header element if everything is ok
-->
<xsl:template match="header">
<header>
<xsl:apply-templates select="@*|*"/>
<dr:dateOfCollection><xsl:value-of select="./dri:dateOfCollection"/></dr:dateOfCollection>
</header>
</xsl:template>

<!-- 
inserts new dmf fields (some values are fixed, others are passed by parameters) 
keeps dc fields (thanx the inner apply-templates)
-->
<xsl:template match="metadata">
	<xsl:copy>
	<xsl:apply-templates select="@*|*|text()" />
	<dr:CobjTypology>Textual</dr:CobjTypology>
	<dr:CobjContentSynthesis></dr:CobjContentSynthesis>
	<dr:CobjModel>OAI</dr:CobjModel>
	<dr:CobjMDFormats>oai_dc</dr:CobjMDFormats>
	<dr:CobjDescriptionSynthesis></dr:CobjDescriptionSynthesis>
	<dr:aggregatorInstitution>ISTI CNR</dr:aggregatorInstitution>
	<dr:aggregatorName>DRIVER</dr:aggregatorName>
	<xsl:if test="starts-with(//dc:identifier,'http') = 0">
		<dr:CobjIdentifier><xsl:value-of select="//dc:identifier"/></dr:CobjIdentifier>	
	</xsl:if>
	<dr:dateOfCollection><xsl:value-of select="datetime:date-time()"/></dr:dateOfCollection>
	<dr:repositoryName><xsl:value-of select="$repositoryName"/></dr:repositoryName>
	<dr:repositoryLink><xsl:value-of select="$repositoryLink"/></dr:repositoryLink>
	<dr:repositoryCountry><xsl:value-of select="$repositoryCountry"/></dr:repositoryCountry>
	<dr:repositoryInstitution><xsl:value-of select="$repositoryInstitution"/> </dr:repositoryInstitution>
	<dr:CobjCategory><xsl:value-of select="//dc:type"/></dr:CobjCategory>
	</xsl:copy>
</xsl:template>


<!-- removes oai_dc:dc element inside metadata keeping its sons-->
<xsl:template match="metadata/oai_dc:dc">
<xsl:for-each select="./*">
	<xsl:copy>
	<xsl:apply-templates select="@*|*|text()" />
	</xsl:copy>
</xsl:for-each>
</xsl:template>

<!--removes some elements from the header (add here templates for every non dri: tags -->
<xsl:template match="header/identifier"/>
<xsl:template match="header/datestamp"/>
<xsl:template match="header/setSpec"/>

</xsl:stylesheet>


