package eu.dnetlib.data.transformation.inspector;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import com.googlecode.sarasvati.mem.MemGraphProcess;

import eu.dnetlib.workflow.GraphProcessRegistry;

public class SimpleTransform {
	private static final Log log = LogFactory.getLog(SimpleTransform.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * workflow graph.
	 */
	private Graph graph;

	/**
	 * workflow process registry.
	 */
	private GraphProcessRegistry processRegistry;

	/**
	 * workflow engine.
	 */
	@Resource
	private transient Engine engine;

	public void transform(String hid, String dataSink) {
		log.info("simple TRANFORMING hid: " + hid + " dataSink: " + dataSink);
		
		final GraphProcess process = new MemGraphProcess(graph);
		
		// TODO: parse TDS profile, extract repo id and associate with it
		processRegistry.associateProcessWithResource(process, hid);

		Env env = process.getEnv();
		env.setAttribute("id", hid);
		env.setAttribute("dataSink", dataSink);

		new Thread(new Runnable() {
			@Override
			public void run() {
				engine.startProcess(process);
			}
		}).start();
	}

	public Graph getGraph() {
		return graph;
	}

	@Required
	public void setGraph(Graph graph) {
		this.graph = graph;
	}

	public GraphProcessRegistry getProcessRegistry() {
		return processRegistry;
	}

	@Required
	public void setProcessRegistry(GraphProcessRegistry processRegistry) {
		this.processRegistry = processRegistry;
	}

	public Engine getEngine() {
		return engine;
	}

	public void setEngine(Engine engine) {
		this.engine = engine;
	}
}
