package eu.dnetlib.data.transformation.inspector;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import eu.dnetlib.data.common.AbstractHarvestJob;

public class TransformJob extends AbstractHarvestJob {
	/**
	 * Harvesting DS id.
	 * 
	 */
	private String hid;

	/**
	 * Where to put the harvested data.
	 */
	private String dataSink;

	private SimpleTransform transformer;

	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException {
		transformer.transform(hid, dataSink);
	}

	public SimpleTransform getTransformer() {
		return transformer;
	}

	public void setTransformer(SimpleTransform transformer) {
		this.transformer = transformer;
	}

	public String getHid() {
		return hid;
	}

	public void setHid(String hid) {
		this.hid = hid;
	}

	public String getDataSink() {
		return dataSink;
	}

	public void setDataSink(String dataSink) {
		this.dataSink = dataSink;
	}

}
