package eu.dnetlib.data.transformation.inspector;

import java.util.Date;
import java.util.UUID;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.HumanTime;

@Controller
public class TransformatorMockInspector {
	private static final Log log = LogFactory.getLog(TransformatorMockInspector.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Start deferred jobs.
	 */
	@Resource(name = "aggregatorJobScheduler")
	private Scheduler jobScheduler;

	/**
	 * Needed because the jobdetail disappears from the scheduler and needs to be registered... WTF?
	 */
	@Resource(name = "transformJob")
	private JobDetail transformJob;
	
	/**
	 * lookup locator.
	 */
	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;
	
	@RequestMapping(value = "/inspector/aggregatorFillRealData-transform.do")
	public String fillRealData(
			@RequestParam("store") final String dataSink,
			@RequestParam("hi") final String hid,
			@RequestParam("name") final String repoName,
			@RequestParam("delay") final String delay) throws SchedulerException {

		final HumanTime delta = HumanTime.eval(delay);

		final long startTime = System.currentTimeMillis() + delta.getDelta();

		final SimpleTrigger trigger = new SimpleTrigger("transformTrigger-" + UUID.randomUUID().toString(), null, new Date(startTime), null, 0, 0L);
		trigger.getJobDataMap().put("hid", hid);
		trigger.getJobDataMap().put("dataSink", dataSink);
		trigger.getJobDataMap().put("name", repoName);
		trigger.getJobDataMap().put("type", "transform");
		trigger.setJobName("transformJob");

		JobDetail tmp = jobScheduler.getJobDetail("transformJob", null);
		if (tmp == null) {
			log.fatal("reregistering job detail");
			jobScheduler.addJob(transformJob, true);
		}

		jobScheduler.scheduleJob(trigger);

		return "redirect:hilist.do";
	}
	
	@RequestMapping(value = "/inspector/transformatorMock-transform.do")
	public String transform(
			@RequestParam("id") final String id) 
		throws SchedulerException, ISLookUpDocumentNotFoundException, ISLookUpException {

		//TODO: perform the query with splittedQueryExecutor.mutableQuery(query, keys...);

		final String dataSink = lookupLocator.getService().getResourceProfileByQuery(
				"//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + id + 
				"']]/BODY/CONFIGURATION/DATA_SINK/string()");
		
		final String repoName = lookupLocator.getService().getResourceProfileByQuery(
				"let $repoId := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + id + 
				"']]//REPOSITORY_SERVICE_IDENTIFIER/string() " +
				"return //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=$repoId]" +
				"/BODY/CONFIGURATION/OFFICIAL_NAME/string()");
		
		log.debug("\n\n dataSink: " + dataSink + "\n repoName: " + repoName);
		
		return "redirect:aggregatorFillRealData-transform.do?"+
				"hi=" + id + 
				"&store=" + dataSink +
				"&name=" + repoName +
				"&delay=";
	}
}
