/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation;

import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import org.springframework.beans.factory.annotation.Required;

public class SimpleDummyTransformationNode
extends BlackboardJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected String locateService(NodeToken token) {
        String tdsId = token.getFullEnv().getAttribute("id");
        String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsId + "']//TRANSFORMATION_MANAGER_SERVICE_IDENTIFIER/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ISLookUpException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        job.setAction("TRANSFORM");
        Env env = token.getFullEnv();
        job.getParameters().put("id", env.getAttribute("id"));
        job.getParameters().put("dataSink", env.getAttribute("dataSink"));
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

