/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation.manager;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.DataSink;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.DataSource;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.transformation.manager.GroovyUnaryFunction;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import groovy.lang.GroovyShell;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class TransformationManagerServiceMockNotificationHandler
extends AbstractBlackboardNotificationHandler<BlackboardServerHandler> {
    private static final Log log = LogFactory.getLog(TransformationManagerServiceMockNotificationHandler.class);
    @Resource
    private SplittedQueryExecutor splittedQueryExecutor;
    private DataSourceResolver dataSourceResolver;
    private DataSinkResolver dataSinkResolver;
    private MappedResultSetFactory mappedResultSetFactory;
    private XSLTMappedResultSetFactory xsltResultSetFactory;
    private org.springframework.core.io.Resource xslt;

    protected void processJob(BlackboardJob job) {
        log.info((Object)("PROCESSING MOCK TMS JOB " + job));
        log.info((Object)("ACTION " + job.getAction()));
        if (job.getAction().equals("TRANSFORM")) {
            String tdsId = (String)job.getParameters().get("id");
            DataSource dataSource = this.getDataSource(tdsId);
            DataSink dataSink = this.dataSinkResolver.resolve((String)job.getParameters().get("dataSink"));
            Map<String, String> params = this.createParameters(tdsId);
            String query = "for $x in collection('/db/DRIVER/TransformationDSResources/TransformationDSResourceType') for $y in collection('/db/DRIVER/GroovyProcessingDSResource/GroovyProcessingDSResourceType') where  $x//RESOURCE_IDENTIFIER/@value = '" + tdsId + "' " + "and $x//TRANSFORMATION_RULE_DS_IDENTIFIER = $y//RESOURCE_IDENTIFIER/@value " + "return concat($y//GROOVY_CLASSPATH, ':-:', $y//GROOVY_DNETCLASS)";
            ArrayList list = Lists.newArrayList((Iterable)this.splittedQueryExecutor.query(query, new String[]{"groovyClasspath", "groovyDnetClass"}));
            try {
                W3CEndpointReference epr = null;
                if (list.size() == 1) {
                    epr = this.transformGroovy(dataSource.retrieve(), (String)((Map)list.get(0)).get("groovyClasspath"), (String)((Map)list.get(0)).get("groovyDnetClass"), params);
                } else {
                    String queryForXSLT = "for $x in collection('/db/DRIVER/TransformationDSResources/TransformationDSResourceType') for $y in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where  $x//RESOURCE_IDENTIFIER/@value = '" + tdsId + "' " + "and $x//TRANSFORMATION_RULE_DS_IDENTIFIER = $y//RESOURCE_IDENTIFIER/@value " + "return $y//CODE/*[local-name()='stylesheet']";
                    List results = ((ISLookUpService)this.splittedQueryExecutor.getLookupLocator().getService()).quickSearchProfile(queryForXSLT);
                    epr = results.size() == 0 ? this.transformXslt(dataSource.retrieve(), params) : this.transformXslt(dataSource.retrieve(), params, (String)results.get(0));
                }
                dataSink.store(epr);
            }
            catch (Exception e) {
                ((BlackboardServerHandler)this.getBlackboardHandler()).failed(job, (Throwable)e);
                throw new IllegalStateException("cannot copy from source to sink", e);
            }
        }
        ((BlackboardServerHandler)this.getBlackboardHandler()).done(job);
    }

    private W3CEndpointReference transformGroovy(W3CEndpointReference source, String groovyClasspath, String groovyDnetClass, Map<String, String> params) throws ClassNotFoundException, IOException {
        GroovyScriptEngine gse = new GroovyScriptEngine(groovyClasspath);
        gse.getGroovyClassLoader().loadClass(groovyDnetClass);
        log.info((Object)"***********************************************");
        log.info((Object)"Loaded Groovy classes:");
        for (Class c : gse.getGroovyClassLoader().getLoadedClasses()) {
            log.info((Object)c.getCanonicalName());
        }
        log.info((Object)"***********************************************");
        GroovyShell groovyShell = new GroovyShell((ClassLoader)gse.getGroovyClassLoader());
        Object go = groovyShell.evaluate("new " + groovyDnetClass + "()");
        if (go instanceof GroovyUnaryFunction) {
            GroovyUnaryFunction groovyUnaryFunction = (GroovyUnaryFunction)go;
            groovyUnaryFunction.setParams(params);
            return this.mappedResultSetFactory.createMappedResultSet(source, (UnaryFunction)groovyUnaryFunction);
        }
        throw new RuntimeException("Groovy object " + go + " is not supported");
    }

    private W3CEndpointReference transformXslt(W3CEndpointReference source, Map<String, String> parameters) {
        return this.xsltResultSetFactory.createMappedResultSet(source, this.xslt, parameters);
    }

    private W3CEndpointReference transformXslt(W3CEndpointReference source, Map<String, String> parameters, String xsltCode) {
        log.debug((Object)"XSLT CODE:");
        log.debug((Object)xsltCode);
        return this.xsltResultSetFactory.createMappedResultSet(source, xsltCode, parameters);
    }

    protected DataSource getDataSource(String tdsId) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsId + "']//DATA_SOURCE/string()";
        return this.dataSourceResolver.resolve(this.splittedQueryExecutor.queryFirst(query));
    }

    protected Map<String, String> createParameters(String tdsId) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=(//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsId + "']//REPOSITORY_SERVICE_IDENTIFIER/text())]";
        try {
            String result = ((ISLookUpService)this.splittedQueryExecutor.getLookupLocator().getService()).getResourceProfileByQuery(query);
            Document doc = new SAXReader().read((Reader)new StringReader(result));
            theMap.put("repositoryCountry", doc.selectSingleNode("//COUNTRY").getText());
            theMap.put("repositoryName", doc.selectSingleNode("//OFFICIAL_NAME").getText());
            theMap.put("repositoryLink", doc.selectSingleNode("//REPOSITORY_WEBPAGE").getText());
            theMap.put("repositoryInstitution", doc.selectSingleNode("//REPOSITORY_INSTITUTION").getText());
            Node datasourceId = doc.selectSingleNode("//FIELD[./key='OpenAireDataSourceId']/value");
            if (datasourceId != null) {
                theMap.put("dataSourceId", datasourceId.getText());
            }
        }
        catch (ISLookUpException e) {
            throw new RuntimeException(e);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        return theMap;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    @Required
    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }

    public XSLTMappedResultSetFactory getXsltResultSetFactory() {
        return this.xsltResultSetFactory;
    }

    @Required
    public void setXsltResultSetFactory(XSLTMappedResultSetFactory xsltResultSetFactory) {
        this.xsltResultSetFactory = xsltResultSetFactory;
    }

    public org.springframework.core.io.Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(org.springframework.core.io.Resource xslt) {
        this.xslt = xslt;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }
}

