/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.sets;

import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.SetCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Required;

public class PredefinedSetCollection
implements SetCollection {
    private static final int NAME_SUFFIX_LEN = 5;
    private Properties properties;

    @Override
    public List<SetInfo> getAllSets() {
        ArrayList<SetInfo> response = new ArrayList<SetInfo>();
        for (Object key : this.properties.keySet()) {
            if (!key.toString().endsWith("_name")) continue;
            String name = this.properties.getProperty(key.toString()).toString();
            SetInfo set = new SetInfo();
            set.setSetSpec(key.toString().substring(0, key.toString().length() - 5));
            set.setSetName(name);
            response.add(set);
        }
        return response;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Required
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean containSet(String set) {
        return this.properties.containsKey(set + "_query") && this.properties.containsKey(set + "_name");
    }

    @Override
    public String getSetQuery(String set) {
        return this.properties.getProperty(set + "_query", "");
    }
}

