/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.info.ListDocumentsInfo;
import eu.dnetlib.data.information.oai.publisher.info.ListRecordsInfo;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractOAICore {
    private static final String SCHEMA_DC_URI = "http://purl.org/dc/elements/1.1/";
    private int resumptionTokenTTL;
    private int userSetsTTL = 2592000;
    protected int pageSize = 100;
    private boolean compositeID = true;

    public RecordInfo getInfoRecord(String identifier, String prefix) throws OaiPublisherException {
        String oaiId;
        String setspec;
        if (identifier.contains("/") && this.compositeID) {
            setspec = identifier.substring(0, identifier.indexOf("/"));
            oaiId = identifier.substring((setspec + "/").length());
        } else {
            setspec = "";
            oaiId = identifier;
        }
        try {
            MDFInfo mdf = this.obtainMDFInfo(prefix);
            String xml = this.getXMLRecordById(mdf, setspec, oaiId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(xml));
            String datestamp = this.getValueOfIndexedDate(doc, mdf);
            String metadata = this.formatMetadataResponse((Element)doc.selectSingleNode("/record/result/metadata"), mdf);
            RecordInfo res = new RecordInfo();
            res.setPrefix(prefix);
            res.setIdentifier(identifier);
            res.setDatestamp(datestamp);
            res.setSetspec(setspec);
            res.setMetadata(metadata);
            return res;
        }
        catch (Exception e) {
            throw new OaiPublisherException("Error accessing document", e);
        }
    }

    protected abstract String getXMLRecordById(MDFInfo var1, String var2, String var3) throws OaiPublisherException;

    public abstract List<? extends SetInfo> listSets() throws OaiPublisherException;

    protected abstract String getValueOfIndexedDate(Document var1, MDFInfo var2) throws OaiPublisherException;

    protected abstract void addOrUpdateSet(SetInfo var1, int var2) throws OaiPublisherException;

    public abstract List<MDFInfo> listMetadataFormats() throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2, String var3, String var4, String var5) throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2) throws OaiPublisherException;

    public List<SetInfo> addOrUpdateSet(SetInfo set) throws OaiPublisherException {
        this.addOrUpdateSet(set, this.userSetsTTL);
        ArrayList<SetInfo> response = new ArrayList<SetInfo>();
        response.add(set);
        return response;
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String metadataPrefix, String set, String from, String until) throws OaiPublisherException {
        ListRecordsInfo res = new ListRecordsInfo();
        if (from != null) {
            res.setFrom(from);
        }
        if (until != null) {
            res.setUntil(until);
        }
        if (metadataPrefix != null) {
            res.setMetadataprefix(metadataPrefix);
        }
        if (set != null) {
            res.setSet(set);
        }
        ListDocumentsInfo documents = this.getDocuments(onlyIdentifiers, set, metadataPrefix, from, until);
        String resumptionToken = documents.getResumptionToken();
        int cursor = documents.getCursor();
        int nMaxElements = documents.getnMaxElements();
        if (onlyIdentifiers) {
            res.setIdentifiers(documents.getDocs());
        } else {
            res.setDocuments(documents.getDocs());
        }
        if (resumptionToken != null && resumptionToken.length() > 0) {
            res.setResumptiontoken(resumptionToken);
            res.setCursor(cursor);
            res.setExpdate(DateUtils.calculate_ISO8601((long)(System.currentTimeMillis() + (long)this.resumptionTokenTTL)));
            res.setSize(nMaxElements);
        }
        return res;
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ListDocumentsInfo docs = this.getDocuments(onlyIdentifiers, resumptionToken);
        if (docs.getDocs().isEmpty()) {
            throw new OaiPublisherException("badResumptionToken");
        }
        ListRecordsInfo res = new ListRecordsInfo();
        if (docs.getMetadataPrefix() != null) {
            res.setMetadataprefix(docs.getMetadataPrefix());
        }
        if (onlyIdentifiers) {
            res.setIdentifiers(docs.getDocs());
        } else {
            res.setDocuments(docs.getDocs());
        }
        String newResumptionToken = docs.getResumptionToken();
        if (newResumptionToken != null && newResumptionToken.length() > 0) {
            res.setResumptiontoken(newResumptionToken);
            res.setCursor(docs.getCursor());
            res.setExpdate(DateUtils.calculate_ISO8601((long)(System.currentTimeMillis() + (long)this.resumptionTokenTTL)));
            res.setSize(docs.getnMaxElements());
        }
        return res;
    }

    protected String formatMetadataResponse(Element node, MDFInfo mdf) throws OaiPublisherException {
        String sl;
        Attribute attr;
        Element root = null;
        if (mdf.getPrefix().equals("DMF") && node.selectNodes("child::*").size() > 1) {
            root = node.createCopy();
            root.setName("dmf:dmf_record");
            root.addAttribute("xmlns:dmf", mdf.getNamespace());
        } else if (mdf.getPrefix().equals("oai_dc") && node.selectNodes("child::*").size() >= 1) {
            root = node.createCopy();
            root.setName("oai_dc:dc");
            root.addAttribute("xmlns:oai_dc", mdf.getNamespace());
        } else {
            root = (Element)node.selectSingleNode("child::*");
        }
        String xsi = root.valueOf("@*[local-name() = 'xsi']");
        if (xsi == null || xsi.isEmpty()) {
            root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        if ((attr = root.attribute("noNamespaceSchemaLocation")) != null) {
            attr.detach();
        }
        if ((sl = root.valueOf("@*[local-name() = 'schemaLocation']")) == null || sl.isEmpty()) {
            root.addAttribute("xsi:schemaLocation", mdf.getNamespace() + " " + mdf.getSchema());
        }
        if (mdf.getPrefix().equals("oai_dc")) {
            List<Element> dcElements = this.getDCElements(root);
            List list = root.elements();
            for (int i = 0; i < list.size(); ++i) {
                Element el = (Element)list.get(i);
                el.detach();
            }
            for (Element e : dcElements) {
                root.add(e);
            }
        }
        return root.asXML();
    }

    protected List<Element> getDCElements(Element el) {
        ArrayList dcList = Lists.newArrayList();
        if (el.getNamespaceURI().equals(SCHEMA_DC_URI)) {
            if (el.getName().equalsIgnoreCase("dateAccepted")) {
                el.setName("dc:date");
                el.addAttribute("xmlns:dc", SCHEMA_DC_URI);
            }
            dcList.add(el.createCopy());
        } else {
            List elements = el.elements();
            for (int i = 0; i < elements.size(); ++i) {
                Element e = (Element)elements.get(i);
                dcList.addAll(this.getDCElements(e));
            }
        }
        return dcList;
    }

    protected MDFInfo obtainMDFInfo(String metadataPrefix) throws OaiPublisherException {
        try {
            for (MDFInfo md : this.listMetadataFormats()) {
                if (!md.getPrefix().equals(metadataPrefix)) continue;
                return md;
            }
        }
        catch (Exception e) {
            throw new OaiPublisherException(e);
        }
        throw new OaiPublisherException("Invalid metadataPrefix " + metadataPrefix);
    }

    @Required
    public void setResumptionTokenTTL(int resumptionTokenTTL) {
        this.resumptionTokenTTL = resumptionTokenTTL;
    }

    @Required
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Required
    public void setUserSetsTTL(int userSetsTTL) {
        this.userSetsTTL = userSetsTTL;
    }

    public boolean isCompositeID() {
        return this.compositeID;
    }

    public void setCompositeID(boolean compositeID) {
        this.compositeID = compositeID;
    }
}

