/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher;

import eu.dnetlib.data.information.oai.publisher.core.AbstractOAICore;
import eu.dnetlib.data.information.oai.publisher.info.ListRecordsInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

public final class OAIController {
    private static final Log log = LogFactory.getLog(OAIController.class);
    private static final String DEFAULT_CONTENT_TYPE = "text/xml;charset=utf-8";
    private String baseUrl;
    private String forwardedUrlHeaderName = "X-Forwarded-Url";
    private static Map<String, String> errMessages = new HashMap<String, String>();
    private AbstractOAICore core;
    private String repoName = "Driver Service for supporting Open Archive Initiative requests";
    private String repoEmail = "artini@isti.cnr.it";
    private String earliestDatestamp = "1970-01-01";

    @RequestMapping(value={"oai.do"})
    public String oai(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(DEFAULT_CONTENT_TYPE);
        try {
            Map<String, String> params = this.cleanParameters(request.getParameterMap());
            if (params == null) {
                return this.oaiError("badArgument", map);
            }
            if (params.get("verb") == null) {
                return this.oaiError("badVerb", map);
            }
            if (params.get("verb").equals("Identify")) {
                return this.oaiIdentify(params, map);
            }
            if (params.get("verb").equals("ListMetadataFormats")) {
                return this.oaiListMetadataFormats(params, map);
            }
            if (params.get("verb").equals("ListSets")) {
                return this.oaiListSets(params, map);
            }
            if (params.get("verb").equals("ListIdentifiers")) {
                return this.oaiListIdentifiersOrRecords(params, map);
            }
            if (params.get("verb").equals("ListRecords")) {
                return this.oaiListIdentifiersOrRecords(params, map);
            }
            if (params.get("verb").equals("GetRecord")) {
                return this.oaiGetRecord(params, map);
            }
            if (params.get("verb").equals("AddOrUpdateSet")) {
                return this.driverAddOrUpdateSet(params, map);
            }
            return this.oaiError("badVerb", map);
        }
        catch (Exception e) {
            log.error((Object)"ERROR", (Throwable)e);
            return this.oaiError(e, map);
        }
    }

    @ModelAttribute(value="url")
    public String url(HttpServletRequest request) {
        String forwardedUrl = request.getHeader(this.forwardedUrlHeaderName);
        if (this.baseUrl != null) {
            return this.baseUrl;
        }
        if (forwardedUrl != null) {
            return forwardedUrl;
        }
        return request.getRequestURL() + "";
    }

    @ModelAttribute(value="repoName")
    public String getRepoName() {
        return this.repoName;
    }

    @ModelAttribute(value="email")
    public String getRepoEmail() {
        return this.repoEmail;
    }

    @ModelAttribute(value="earliestDatestamp")
    public String getEarliestDatestamp() {
        return this.earliestDatestamp;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public void setRepoEmail(String repoEmail) {
        this.repoEmail = repoEmail;
    }

    public void setEarliestDatestamp(String earliestDatestamp) {
        this.earliestDatestamp = earliestDatestamp;
    }

    @ModelAttribute(value="date")
    public String date() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = formatter.format(new Date());
        return date.replace("+0000", "Z");
    }

    private Map<String, String> cleanParameters(Map<?, ?> startParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : startParams.entrySet()) {
            String key = entry.getKey().toString();
            String[] arr = (String[])entry.getValue();
            if (arr.length == 0) {
                return null;
            }
            String value = arr[0];
            if (key.equals("verb")) {
                params.put("verb", value);
                continue;
            }
            if (key.equals("from")) {
                params.put("from", value);
                continue;
            }
            if (key.equals("until")) {
                params.put("until", value);
                continue;
            }
            if (key.equals("metadataPrefix")) {
                params.put("metadataPrefix", value);
                continue;
            }
            if (key.equals("identifier")) {
                params.put("identifier", value);
                continue;
            }
            if (key.equals("set")) {
                params.put("set", value);
                continue;
            }
            if (key.equals("resumptionToken")) {
                params.put("resumptionToken", value);
                continue;
            }
            if (key.equals("name")) {
                params.put("name", value);
                continue;
            }
            if (key.equals("query")) {
                params.put("query", value);
                continue;
            }
            return null;
        }
        return params;
    }

    private String oaiIdentify(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError("badArgument", verb, map);
        }
        return "oai/OAI_Identify";
    }

    private String oaiGetRecord(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        String prefix = null;
        String identifier = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (!params.containsKey("metadataPrefix")) {
            return this.oaiError("badArgument", verb, map);
        }
        prefix = params.get("metadataPrefix");
        params.remove("metadataPrefix");
        if (!params.containsKey("identifier")) {
            return this.oaiError("badArgument", verb, map);
        }
        identifier = params.get("identifier");
        params.remove("identifier");
        if (params.entrySet().size() > 0) {
            return this.oaiError("badArgument", verb, map);
        }
        map.addAttribute("record", (Object)this.core.getInfoRecord(identifier, prefix));
        return "oai/OAI_GetRecord";
    }

    private String oaiListIdentifiersOrRecords(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        String metadataPrefix = null;
        String resumptionToken = null;
        String set = null;
        String from = null;
        String until = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.containsKey("resumptionToken")) {
            resumptionToken = params.get("resumptionToken");
            params.remove("resumptionToken");
        } else {
            if (!params.containsKey("metadataPrefix")) {
                return this.oaiError("badArgument", verb, map);
            }
            metadataPrefix = params.get("metadataPrefix");
            params.remove("metadataPrefix");
            if (params.containsKey("from")) {
                from = params.get("from");
                params.remove("from");
            }
            if (params.containsKey("until")) {
                until = params.get("until");
                params.remove("until");
            }
            if (params.containsKey("set")) {
                set = params.get("set");
                params.remove("set");
            }
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError("badArgument", verb, map);
        }
        boolean onlyIdentifiers = true;
        if (verb.equals("ListRecords")) {
            onlyIdentifiers = false;
        }
        ListRecordsInfo infos = resumptionToken == null ? this.core.listRecords(onlyIdentifiers, metadataPrefix, set, from, until) : this.core.listRecords(onlyIdentifiers, resumptionToken);
        map.addAttribute("info", (Object)infos);
        if (verb.equals("ListRecords")) {
            return "oai/OAI_ListRecords";
        }
        return "oai/OAI_ListIdentifiers";
    }

    private String oaiListSets(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError("badArgument", verb, map);
        }
        map.addAttribute("sets", this.core.listSets());
        return "oai/OAI_ListSets";
    }

    private String oaiListMetadataFormats(Map<String, String> params, ModelMap map) throws Exception {
        String id = null;
        String verb = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.containsKey("identifier")) {
            id = params.get("identifier");
            params.remove("identifier");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError("badArgument", verb, map);
        }
        map.addAttribute("formats", this.core.listMetadataFormats());
        if (id != null) {
            map.addAttribute("identifier", (Object)id);
            return "oai/OAI_ListMetadataFormats_withid";
        }
        return "oai/OAI_ListMetadataFormats";
    }

    private String driverAddOrUpdateSet(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        String setSpec = null;
        String setName = null;
        String query = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.containsKey("set")) {
            setSpec = params.get("set");
            params.remove("set");
        }
        if (params.containsKey("name")) {
            setName = params.get("name");
            params.remove("name");
        }
        if (params.containsKey("query")) {
            query = params.get("query");
            params.remove("query");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError("badArgument", verb, map);
        }
        map.addAttribute("sets", this.core.addOrUpdateSet(new SetInfo(setSpec, setName, query)));
        return "oai/OAI_ListSets";
    }

    private String oaiError(String errCode, String verb, ModelMap map) throws Exception {
        if (verb == null || verb.equals("")) {
            return this.oaiError(errCode, map);
        }
        map.addAttribute("verb", (Object)verb);
        map.addAttribute("errcode", (Object)errCode);
        map.addAttribute("errmsg", (Object)errMessages.get(errCode));
        return "oai/OAI_Error";
    }

    private String oaiError(String errCode, ModelMap map) throws Exception {
        map.addAttribute("errcode", (Object)errCode);
        map.addAttribute("errmsg", (Object)errMessages.get(errCode));
        return "oai/OAI_Error_noverb";
    }

    private String oaiError(Exception e, ModelMap map) throws Exception {
        map.addAttribute("errcode", (Object)"InternalException");
        map.addAttribute("errmsg", (Object)e.getMessage());
        return "oai/OAI_Error_noverb";
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public AbstractOAICore getCore() {
        return this.core;
    }

    @Required
    public void setCore(AbstractOAICore core) {
        this.core = core;
    }

    public String getForwardedUrlHeaderName() {
        return this.forwardedUrlHeaderName;
    }

    public void setForwardedUrlHeaderName(String forwardedUrlHeaderName) {
        this.forwardedUrlHeaderName = forwardedUrlHeaderName;
    }

    static {
        errMessages.put("badArgument", "The request includes illegal arguments, is missing required arguments, includes a repeated argument, or values for arguments have an illegal syntax.");
        errMessages.put("badVerb", "Value of the verb argument is not a legal OAI-PMH verb, the verb argument is missing, or the verb argument is repeated.");
        errMessages.put("cannotDisseminateFormat", "The metadata format identified by the value given for the metadataPrefix argument is not supported by the item or by the repository.");
        errMessages.put("idDoesNotExist", "The value of the identifier argument is unknown or illegal in this repository.");
        errMessages.put("noMetadataFormats", "There are no metadata formats available for the specified item.");
        errMessages.put("noSetHierarchy", "The repository does not support sets.");
        errMessages.put("noRecordsMatch", "The combination of the values of the from, until, set and metadataPrefix arguments results in an empty list.");
        errMessages.put("badResumptionToken", "The value of the resumptionToken argument is invalid or expired.");
    }
}

