/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.sets;

import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.SetCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDefinedSetCollection
implements SetCollection {
    private static final String OAISET_PREFIX = "oaiset_";
    private static final int MAX_IN_MEMORY = 5000;
    private static CacheManager cacheManager = CacheManager.create();
    private static final Log log = LogFactory.getLog(UserDefinedSetCollection.class);

    public void addOrUpdateSet(SetInfo set, int ttl) {
        String cacheName = OAISET_PREFIX + set.getSetSpec();
        Cache cache = null;
        if (cacheManager.cacheExists(cacheName)) {
            cache = cacheManager.getCache(cacheName);
        } else {
            cache = new Cache(cacheName, 5000, false, false, (long)ttl, (long)ttl);
            cacheManager.addCache(cache);
        }
        cache.put(new Element((Object)"set", (Object)set));
    }

    @Override
    public boolean containSet(String set) {
        return cacheManager.cacheExists(OAISET_PREFIX + set);
    }

    @Override
    public List<SetInfo> getAllSets() {
        ArrayList<SetInfo> response = new ArrayList<SetInfo>();
        for (String spec : cacheManager.getCacheNames()) {
            SetInfo set;
            Element elem;
            Cache cache;
            if (!spec.startsWith(OAISET_PREFIX) || (cache = cacheManager.getCache(spec)) == null || (elem = cache.get((Serializable)((Object)"set"))) == null || (set = (SetInfo)cache.get((Serializable)((Object)"set")).getObjectValue()) == null) continue;
            response.add(set);
        }
        return response;
    }

    @Override
    public String getSetQuery(String set) {
        Cache cache = cacheManager.getCache(OAISET_PREFIX + set);
        if (cache == null) {
            return "";
        }
        Element elem = cache.get((Serializable)((Object)"set"));
        if (elem == null) {
            return "";
        }
        SetInfo setInfo = (SetInfo)elem.getObjectValue();
        if (setInfo == null) {
            return "";
        }
        return setInfo.getQuery();
    }
}

