package eu.dnetlib.data.information.oai.publisher.core;

public interface ResumptionToken {

	/**
	 * Serializes the resumption token.
	 * 
	 * @return a String serialization of this token.
	 */
	public String serialize();

	/**
	 * Deserializes the resumption token and sets the properties of this token accordingly.
	 * 
	 * @param token
	 *            a String serialization of this token.
	 */
	public void deserialize(String token);

	/**
	 * Gets the total number of documents.
	 * 
	 * @return the total number of documents
	 */
	public int getnMaxElements();

	/**
	 * Sets the total number of documents.
	 * 
	 * @param nMaxElements
	 *            the total number of documents
	 */
	public void setnMaxElements(int nMaxElements);

	/**
	 * Gets the requested metadata prefix.
	 * 
	 * @return the metadata prefix
	 */
	public String getMetadataPrefix();

	/**
	 * Sets the requested metadata prefix.
	 * 
	 * @param metadataPrefix
	 */
	public void setMetadataPrefix(String metadataPrefix);

	/**
	 * Gets the requested query.
	 * 
	 * @return the requested query
	 */
	public String getQuery();

	/**
	 * Sets the requested query.
	 * 
	 * @param query
	 *            the requested query
	 */
	public void setQuery(String query);

	/**
	 * Gets the number of already read records.
	 * 
	 * @return the number of already read records.
	 */
	public int getnRead();

	/**
	 * Sets the number of already read records.
	 * 
	 * @param nRead
	 *            the number of already read records.
	 */
	public void setnRead(int nRead);

	/**
	 * Gets the identifier of the last returned document.
	 * 
	 * @return the identifier of the last returned document
	 */
	public String getLastObjIdentifier();

	/**
	 * Sets the identifier of the last returned document.
	 * 
	 * @param lastObjIdentifier
	 *            the identifier of the last returned document
	 */
	public void setLastObjIdentifier(String lastObjIdentifier);

	/**
	 * Gets the requested set.
	 * 
	 * @return the requested set
	 */
	public String getRequestedSet();

	/**
	 * Sets the requested set.
	 * 
	 * @param requestedSet
	 *            the name of the requested set
	 */
	public void setRequestedSet(String requestedSet);

}
