package eu.dnetlib.data.information.oai.publisher.core;

import org.dom4j.Document;
import org.dom4j.Node;

import eu.dnetlib.miscutils.functional.UnaryFunction;

/**
 * Function to skip the header of the record and deliver only its metadata content as XML String.
 */
public class MetadataExtractor implements UnaryFunction<String, Document> {

	@Override
	public String evaluate(final Document xmlDoc) {
		Node metadataNode = xmlDoc.selectSingleNode("//metadata");
		return metadataNode.asXML();
	}
}
