package eu.dnetlib.data.information.oai.publisher.sets;

import java.util.List;

import eu.dnetlib.data.information.oai.publisher.info.SetInfo;

/**
 * Collection of sets.
 * 
 * @author michele
 * 
 */
public interface SetCollection {

	/**
	 * get all sets.
	 * 
	 * @return list maps of (setSpec,setName)
	 */
	List<SetInfo> getAllSets();

	/**
	 * Test if a set is in this collection.
	 * 
	 * @param set
	 *            set name
	 * @return true if the set is in this collection
	 */
	boolean containSet(String set);

	/**
	 * Obtains the set query.
	 * 
	 * @param set
	 *            set name
	 * @return set CQL query
	 */
	String getSetQuery(String set);

}
