package eu.dnetlib.data.information.oai.publisher.info;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.time.DateFormatUtils;

import com.google.common.collect.Lists;

public class RecordInfo {

	private String prefix = "";
	private String identifier = "";
	private Date datestamp = null;
	private List<String> setspecs = Lists.newArrayList();
	private String metadata = "";
	private String internalId = "";
	private boolean deleted;

	public RecordInfo() {}

	public RecordInfo(final String prefix, final String identifier, final Date datestamp, final String setspec, final String metadata, final boolean deleted) {
		this(prefix, identifier, datestamp, Lists.newArrayList(setspec), metadata, deleted);
	}

	public RecordInfo(final String prefix, final String identifier, final Date datestamp, final List<String> setspecs, final String metadata,
			final boolean deleted) {
		super();
		this.prefix = prefix;
		this.identifier = identifier;
		this.datestamp = datestamp;
		this.setspecs = setspecs;
		this.metadata = metadata;
		this.deleted = deleted;
	}

	public boolean addSetspec(final String setspec) {
		if (!setspecs.contains(setspec)) {
			setspecs.add(setspec);
			return true;
		} else {
			return false;
		}
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(final String prefix) {
		this.prefix = prefix;
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(final String identifier) {
		this.identifier = identifier;
	}

	public Date getDatestamp() {
		return datestamp;
	}

	public void setDatestamp(final Date datestamp) {
		this.datestamp = datestamp;
	}

	public List<String> getSetspecs() {
		return setspecs;
	}

	public void setSetspecs(final List<String> setspecs) {
		this.setspecs = setspecs;
	}

	public String getMetadata() {
		return metadata;
	}

	public void setMetadata(final String metadata) {
		this.metadata = metadata;
	}

	/**
	 * Converts UTC date format 2010-09-27T11:10:33+02:00 into ISO 8601 date formatted as: 2009-10-21T08:28:03z.
	 * 
	 * @return the date formatted in ISO8601, UTC
	 */
	public String getNormalizedDatestamp() {
		return DateFormatUtils.ISO_DATETIME_FORMAT.format(datestamp) + 'z';
	}

	public String getInternalId() {
		return internalId;
	}

	public void setInternalId(final String internalId) {
		this.internalId = internalId;
	}

	public boolean isDeleted() {
		return deleted;
	}

	public void setDeleted(final boolean deleted) {
		this.deleted = deleted;
	}

}
