/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.core.ResumptionToken;
import eu.dnetlib.data.information.oai.publisher.info.ListDocumentsInfo;
import eu.dnetlib.data.information.oai.publisher.info.ListRecordsInfo;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import java.util.List;

public abstract class AbstractOAICore {
    protected int pageSize = 100;

    public RecordInfo getInfoRecord(String identifier, String prefix) throws OaiPublisherException {
        MDFInfo mdf = this.obtainMDFInfo(prefix);
        return this.getRecordById(mdf, identifier);
    }

    protected abstract RecordInfo getRecordById(MDFInfo var1, String var2) throws OaiPublisherException;

    public abstract List<? extends SetInfo> listSets() throws OaiPublisherException;

    public abstract List<MDFInfo> listMetadataFormats() throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2, String var3, String var4, String var5) throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2) throws OaiPublisherException;

    protected abstract MDFInfo obtainMDFInfo(String var1) throws OaiPublisherException;

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String metadataPrefix, String set, String from, String until) throws OaiPublisherException {
        ListRecordsInfo res = new ListRecordsInfo();
        if (from != null) {
            res.setFrom(from);
        }
        if (until != null) {
            res.setUntil(until);
        }
        if (metadataPrefix != null) {
            res.setMetadataprefix(metadataPrefix);
        }
        if (set != null) {
            res.setSet(set);
        }
        ListDocumentsInfo documents = this.getDocuments(onlyIdentifiers, set, metadataPrefix, from, until);
        ResumptionToken resumptionToken = documents.getResumptionToken();
        int cursor = documents.getCursor();
        int nMaxElements = documents.getnMaxElements();
        if (onlyIdentifiers) {
            res.setIdentifiers(documents.getDocs());
        } else {
            res.setDocuments(documents.getDocs());
        }
        if (resumptionToken != null) {
            res.setResumptiontoken(resumptionToken.serialize());
            res.setCursor(cursor);
            res.setSize(nMaxElements);
        }
        return res;
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ListDocumentsInfo docs = this.getDocuments(onlyIdentifiers, resumptionToken);
        ListRecordsInfo res = new ListRecordsInfo();
        if (docs.getMetadataPrefix() != null) {
            res.setMetadataprefix(docs.getMetadataPrefix());
        }
        if (onlyIdentifiers) {
            res.setIdentifiers(docs.getDocs());
        } else {
            res.setDocuments(docs.getDocs());
        }
        ResumptionToken newResumptionToken = docs.getResumptionToken();
        if (newResumptionToken != null) {
            res.setResumptiontoken(newResumptionToken.serialize());
            res.setCursor(docs.getCursor());
            res.setSize(docs.getnMaxElements());
        }
        return res;
    }
}

