package eu.dnetlib.data.information.oai.publisher.store;

import com.google.common.collect.Multimap;

/**
 * Instances of this class represent fields to be explicitely managed by the OAI Publisher, for example for indexing purposes.
 * 
 * @author alessia
 * 
 */
public class PublisherField {

	/**
	 * Name of the field.
	 */
	private String fieldName;
	/**
	 * True if the value of the field is a list (i.e. repeatable values). False otherwise.
	 **/
	private boolean repeatable;
	/**
	 * Information about where to take values for this field. Keys are metadat format: name-layout-interpretation; values are xpaths.
	 */
	private Multimap<String, String> sources;

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(final String fieldName) {
		this.fieldName = fieldName;
	}

	public boolean isRepeatable() {
		return repeatable;
	}

	public void setRepeatable(final boolean repeatable) {
		this.repeatable = repeatable;
	}

	public Multimap<String, String> getSources() {
		return sources;
	}

	public void setSources(final Multimap<String, String> sources) {
		this.sources = sources;
	}

}
