package eu.dnetlib.data.information.oai.publisher.info;

public class MDFInfo {

	/**
	 * prefix, schema and namespace are properties describing the metadata format exported via OAI PMH.
	 */
	private String prefix;
	private String schema;
	private String namespace;

	/**
	 * sourceFormat* are properties describing the metadata format to use as input to deliver records in the <prefix> format.
	 * sourceFormatName may be the same as prefix, for example in cases when we have a oai_dc store and we want to deliver oai_dc records.
	 */
	private String sourceFormatName;
	private String sourceFormatLayout;
	private String sourceFormatInterpretation;

	/**
	 * query to filter out records to be delivered.
	 */
	private String baseQuery;
	/**
	 * identificator of the TDS profile containing an XSLT to be applied to records of <sourceFormatName> before delivering. The
	 * transformation transforms them into the <prefix> metadata format. This property can be null/empty in cases when the delivered format
	 * is the same of the source format.
	 */
	private String transformationRuleID;

	/**
	 * Tells if the metadata format is enabled for export. If not, it won't appear in the ListMetadataFormats response.
	 */
	private boolean enabled;

	public MDFInfo() {}

	public MDFInfo(final String prefix, final String schema, final String namespace, final String sourceFormatName, final String sourceFormatLayout,
			final String sourceFormatInterpretation, final String baseQuery, final boolean enabled) {
		super();
		initCommonFields(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery);
		this.enabled = enabled;
	}

	/**
	 * This constructor is the same as the above, but in this case "enabled" is a string, so we can use the SplittedQueryExecutor to
	 * generate instances of this class from the information stored in the D-Net IS.
	 * 
	 * @param prefix
	 * @param schema
	 * @param namespace
	 * @param sourceFormatName
	 * @param sourceFormatLayout
	 * @param sourceFormatInterpretation
	 * @param baseQuery
	 * @param enabled
	 */
	public MDFInfo(final String prefix, final String schema, final String namespace, final String sourceFormatName, final String sourceFormatLayout,
			final String sourceFormatInterpretation, final String baseQuery, final String enabled) {
		super();
		initCommonFields(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery);
		this.enabled = Boolean.valueOf(enabled);
	}

	public MDFInfo(final String prefix, final String schema, final String namespace, final String sourceFormatName, final String sourceFormatLayout,
			final String sourceFormatInterpretation, final String baseQuery, final String tdsID, final boolean enabled) {
		this(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery, enabled);
		transformationRuleID = tdsID;
	}

	/**
	 * This constructor is the same as the above, but in this case "enabled" is a string, so we can use the SplittedQueryExecutor to
	 * generate instances of this class from the information stored in the D-Net IS.
	 * 
	 * @param prefix
	 * @param schema
	 * @param namespace
	 * @param sourceFormatName
	 * @param sourceFormatLayout
	 * @param sourceFormatInterpretation
	 * @param baseQuery
	 * @param tdsID
	 * @param enabled
	 */
	public MDFInfo(final String prefix, final String schema, final String namespace, final String sourceFormatName, final String sourceFormatLayout,
			final String sourceFormatInterpretation, final String baseQuery, final String tdsID, final String enabled) {
		this(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery, enabled);
		transformationRuleID = tdsID;
	}

	private void initCommonFields(final String prefix,
			final String schema,
			final String namespace,
			final String sourceFormatName,
			final String sourceFormatLayout,
			final String sourceFormatInterpretation,
			final String baseQuery) {
		this.prefix = prefix;
		this.schema = schema;
		this.namespace = namespace;
		this.sourceFormatName = sourceFormatName;
		this.sourceFormatLayout = sourceFormatLayout;
		this.sourceFormatInterpretation = sourceFormatInterpretation;
		this.baseQuery = baseQuery;
	}

	@Override
	public String toString() {
		return "MDFInfo [prefix=" + prefix + ", schema=" + schema + ", namespace=" + namespace + ", sourceFormatName=" + sourceFormatName
				+ ", sourceFormatLayout=" + sourceFormatLayout + ", sourceFormatInterpretation=" + sourceFormatInterpretation + ", baseQuery=" + baseQuery
				+ ", transformationRuleID=" + transformationRuleID + ", enabled=" + enabled + "]";
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(final String prefix) {
		this.prefix = prefix;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(final String schema) {
		this.schema = schema;
	}

	public String getNamespace() {
		return namespace;
	}

	public void setNamespace(final String namespace) {
		this.namespace = namespace;
	}

	public String getSourceFormatName() {
		return sourceFormatName;
	}

	public void setSourceFormatName(final String sourceFormatName) {
		this.sourceFormatName = sourceFormatName;
	}

	public String getSourceFormatLayout() {
		return sourceFormatLayout;
	}

	public void setSourceFormatLayout(final String sourceFormatLayout) {
		this.sourceFormatLayout = sourceFormatLayout;
	}

	public String getSourceFormatInterpretation() {
		return sourceFormatInterpretation;
	}

	public void setSourceFormatInterpretation(final String sourceFormatInterpretation) {
		this.sourceFormatInterpretation = sourceFormatInterpretation;
	}

	public String getBaseQuery() {
		return baseQuery;
	}

	public void setBaseQuery(final String baseQuery) {
		this.baseQuery = baseQuery;
	}

	public String getTransformationRuleID() {
		return transformationRuleID;
	}

	public void setTransformationRuleID(final String transformationRuleID) {
		this.transformationRuleID = transformationRuleID;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(final boolean enabled) {
		this.enabled = enabled;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + ((baseQuery == null) ? 0 : baseQuery.hashCode());
		result = (prime * result) + (enabled ? 1231 : 1237);
		result = (prime * result) + ((namespace == null) ? 0 : namespace.hashCode());
		result = (prime * result) + ((prefix == null) ? 0 : prefix.hashCode());
		result = (prime * result) + ((schema == null) ? 0 : schema.hashCode());
		result = (prime * result) + ((sourceFormatInterpretation == null) ? 0 : sourceFormatInterpretation.hashCode());
		result = (prime * result) + ((sourceFormatLayout == null) ? 0 : sourceFormatLayout.hashCode());
		result = (prime * result) + ((sourceFormatName == null) ? 0 : sourceFormatName.hashCode());
		result = (prime * result) + ((transformationRuleID == null) ? 0 : transformationRuleID.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (!(obj instanceof MDFInfo)) return false;
		MDFInfo other = (MDFInfo) obj;
		if (baseQuery == null) {
			if (other.baseQuery != null) return false;
		} else if (!baseQuery.equals(other.baseQuery)) return false;
		if (enabled != other.enabled) return false;
		if (namespace == null) {
			if (other.namespace != null) return false;
		} else if (!namespace.equals(other.namespace)) return false;
		if (prefix == null) {
			if (other.prefix != null) return false;
		} else if (!prefix.equals(other.prefix)) return false;
		if (schema == null) {
			if (other.schema != null) return false;
		} else if (!schema.equals(other.schema)) return false;
		if (sourceFormatInterpretation == null) {
			if (other.sourceFormatInterpretation != null) return false;
		} else if (!sourceFormatInterpretation.equals(other.sourceFormatInterpretation)) return false;
		if (sourceFormatLayout == null) {
			if (other.sourceFormatLayout != null) return false;
		} else if (!sourceFormatLayout.equals(other.sourceFormatLayout)) return false;
		if (sourceFormatName == null) {
			if (other.sourceFormatName != null) return false;
		} else if (!sourceFormatName.equals(other.sourceFormatName)) return false;
		if (transformationRuleID == null) {
			if (other.transformationRuleID != null) return false;
		} else if (!transformationRuleID.equals(other.transformationRuleID)) return false;
		return true;
	}

}
